/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.tar;

class TarUtils {
    private static final int BYTE_MASK = 255;

    TarUtils() {
    }

    public static long parseOctal(byte[] header2, int offset2, int length) {
        long result2 = 0L;
        boolean stillPadding = true;
        int end = offset2 + length;
        for (int i2 = offset2; i2 < end && header2[i2] != 0; ++i2) {
            if (header2[i2] == 32 || header2[i2] == 48) {
                if (stillPadding) continue;
                if (header2[i2] == 32) break;
            }
            stillPadding = false;
            result2 = (result2 << 3) + (long)(header2[i2] - 48);
        }
        return result2;
    }

    public static StringBuffer parseName(byte[] header2, int offset2, int length) {
        StringBuffer result2 = new StringBuffer(length);
        int end = offset2 + length;
        for (int i2 = offset2; i2 < end && header2[i2] != 0; ++i2) {
            result2.append((char)header2[i2]);
        }
        return result2;
    }

    public static int getNameBytes(StringBuffer name, byte[] buf, int offset2, int length) {
        int i2;
        for (i2 = 0; i2 < length && i2 < name.length(); ++i2) {
            buf[offset2 + i2] = (byte)name.charAt(i2);
        }
        while (i2 < length) {
            buf[offset2 + i2] = 0;
            ++i2;
        }
        return offset2 + length;
    }

    public static int getOctalBytes(long value, byte[] buf, int offset2, int length) {
        int idx = length - 1;
        buf[offset2 + idx] = 0;
        buf[offset2 + --idx] = 32;
        --idx;
        if (value == 0L) {
            buf[offset2 + idx] = 48;
            --idx;
        } else {
            for (long val = value; idx >= 0 && val > 0L; val >>= 3, --idx) {
                buf[offset2 + idx] = (byte)(48 + (byte)(val & 7L));
            }
        }
        while (idx >= 0) {
            buf[offset2 + idx] = 32;
            --idx;
        }
        return offset2 + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset2, int length) {
        byte[] temp = new byte[length + 1];
        TarUtils.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset2, length);
        return offset2 + length;
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset2, int length) {
        TarUtils.getOctalBytes(value, buf, offset2, length);
        buf[offset2 + length - 1] = 32;
        buf[offset2 + length - 2] = 0;
        return offset2 + length;
    }

    public static long computeCheckSum(byte[] buf) {
        long sum = 0L;
        for (int i2 = 0; i2 < buf.length; ++i2) {
            sum += (long)(0xFF & buf[i2]);
        }
        return sum;
    }
}

