/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.util.containers.ContainerUtil;
import java.beans.Introspector;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class GCUtil {
    public static void tryForceGC() {
        GCUtil.tryGcSoftlyReachableObjects();
        WeakReference<Object> weakReference = new WeakReference<Object>(new Object());
        do {
            System.gc();
        } while (weakReference.get() != null);
    }

    public static void tryGcSoftlyReachableObjects() {
        ReferenceQueue q2 = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q2);
        ArrayList<SoftReference> list2 = ContainerUtil.newArrayListWithCapacity(100 + GCUtil.useReference(ref));
        System.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        for (int i2 = 0; i2 < 100 && q2.poll() == null; ++i2) {
            int bytes = Math.min((int)((double)freeMemory * 0.45), 0x3FFFFFFF);
            list2.add(new SoftReference<byte[]>(new byte[bytes]));
        }
        list2.ensureCapacity(list2.size() + GCUtil.useReference(ref));
        for (SoftReference createdReference : list2) {
            createdReference.clear();
        }
    }

    private static int useReference(SoftReference<Object> ref) {
        Object o = ref.get();
        return o == null ? 0 : Math.abs(o.hashCode()) % 10;
    }

    public static void clearBeanInfoCache() {
        Introspector.flushCaches();
    }
}

