/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.CommonBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.text.SyncDateFormat;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class DateFormatUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.util.text.DateFormatUtil");
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final long DAY_FACTOR = 86400000L;
    private static final SyncDateFormat DATE_FORMAT;
    private static final SyncDateFormat TIME_FORMAT;
    private static final SyncDateFormat TIME_WITH_SECONDS_FORMAT;
    private static final SyncDateFormat DATE_TIME_FORMAT;
    private static final SyncDateFormat ABOUT_DATE_FORMAT;
    private static final SyncDateFormat ISO8601_FORMAT;
    private static final long[] DENOMINATORS;
    private static final Period[] PERIODS;

    private DateFormatUtil() {
    }

    public static long getDifferenceInDays(@NotNull Date startDate, @NotNull Date endDate) {
        if (startDate == null) {
            DateFormatUtil.$$$reportNull$$$0(0);
        }
        if (endDate == null) {
            DateFormatUtil.$$$reportNull$$$0(1);
        }
        return (endDate.getTime() - startDate.getTime() + 86400000L - 1000L) / 86400000L;
    }

    @NotNull
    public static SyncDateFormat getDateFormat() {
        SyncDateFormat syncDateFormat = DATE_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(2);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeFormat() {
        SyncDateFormat syncDateFormat = TIME_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(3);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeWithSecondsFormat() {
        SyncDateFormat syncDateFormat = TIME_WITH_SECONDS_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(4);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getDateTimeFormat() {
        SyncDateFormat syncDateFormat = DATE_TIME_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(5);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getIso8601Format() {
        SyncDateFormat syncDateFormat = ISO8601_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(6);
        }
        return syncDateFormat;
    }

    @NotNull
    public static String formatTime(@NotNull Date time2) {
        if (time2 == null) {
            DateFormatUtil.$$$reportNull$$$0(7);
        }
        String string = DateFormatUtil.formatTime(time2.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String formatTime(long time2) {
        String string = DateFormatUtil.getTimeFormat().format(time2);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String formatTimeWithSeconds(@NotNull Date time2) {
        if (time2 == null) {
            DateFormatUtil.$$$reportNull$$$0(10);
        }
        String string = DateFormatUtil.formatTimeWithSeconds(time2.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String formatTimeWithSeconds(long time2) {
        String string = DateFormatUtil.getTimeWithSecondsFormat().format(time2);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String formatDate(@NotNull Date time2) {
        if (time2 == null) {
            DateFormatUtil.$$$reportNull$$$0(13);
        }
        String string = DateFormatUtil.formatDate(time2.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String formatDate(long time2) {
        String string = DateFormatUtil.getDateFormat().format(time2);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDate(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(16);
        }
        String string = DateFormatUtil.formatPrettyDate(date.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDate(long time2) {
        String string = DateFormatUtil.doFormatPretty(time2, false);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(Date date) {
        String string = DateFormatUtil.formatDateTime(date.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(long time2) {
        String string = DateFormatUtil.getDateTimeFormat().format(time2);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDateTime(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(21);
        }
        String string = DateFormatUtil.formatPrettyDateTime(date.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String formatPrettyDateTime(long time2) {
        String string = DateFormatUtil.doFormatPretty(time2, true);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String doFormatPretty(long time2, boolean formatTime) {
        boolean isYesterday;
        boolean isToday;
        long delta;
        long currentTime = Clock.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentTime);
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time2);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (LOG.isTraceEnabled()) {
            LOG.trace("now=" + currentTime + " t=" + time2 + " z=" + c.getTimeZone());
        }
        if (formatTime && (delta = currentTime - time2) >= 0L && delta <= 3660000L) {
            String string = CommonBundle.message("date.format.minutes.ago", (int)Math.rint((double)delta / 60000.0));
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        boolean bl = isToday = currentYear == year && currentDayOfYear == dayOfYear;
        if (isToday) {
            String result2 = CommonBundle.message("date.format.today", new Object[0]);
            String string = formatTime ? result2 + " " + TIME_FORMAT.format(time2) : result2;
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl2 = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            String result3 = CommonBundle.message("date.format.yesterday", new Object[0]);
            String string = formatTime ? result3 + " " + TIME_FORMAT.format(time2) : result3;
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = formatTime ? DATE_TIME_FORMAT.format(time2) : DATE_FORMAT.format(time2);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String formatDuration(long delta) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < DENOMINATORS.length; ++i2) {
            long denominator = DENOMINATORS[i2];
            int n = (int)(delta / denominator);
            if (n == 0) continue;
            buf.append(DateFormatUtil.composeDurationMessage(PERIODS[i2], n));
            buf.append(' ');
            delta %= denominator;
        }
        if (buf.length() == 0) {
            String string = CommonBundle.message("date.format.less.than.a.minute", new Object[0]);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = buf.toString().trim();
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static String composeDurationMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.n.years", n);
    }

    @NotNull
    public static String formatFrequency(long time2) {
        String string = CommonBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(time2, 0L));
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String formatBetweenDates(long d1, long d2) {
        int i2;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            String string = CommonBundle.message("date.format.right.now", new Object[0]);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        int n = -1;
        for (i2 = 0; i2 < DENOMINATORS.length; ++i2) {
            long denominator = DENOMINATORS[i2];
            if (delta < denominator) continue;
            n = (int)(delta / denominator);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                String string = CommonBundle.message("date.format.a.few.moments.ago", new Object[0]);
                if (string == null) {
                    DateFormatUtil.$$$reportNull$$$0(32);
                }
                return string;
            }
            String string = DateFormatUtil.someTimeAgoMessage(PERIODS[i2], n);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (d2 < d1) {
            if (n <= 0) {
                String string = CommonBundle.message("date.format.in.a.few.moments", new Object[0]);
                if (string == null) {
                    DateFormatUtil.$$$reportNull$$$0(34);
                }
                return string;
            }
            String string = DateFormatUtil.composeInSomeTimeMessage(PERIODS[i2], n);
            if (string == null) {
                DateFormatUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        if ("" == null) {
            DateFormatUtil.$$$reportNull$$$0(36);
        }
        return "";
    }

    @NotNull
    public static String formatAboutDialogDate(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(37);
        }
        String string = DateFormatUtil.formatAboutDialogDate(date.getTime());
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public static String formatAboutDialogDate(long time2) {
        String string = ABOUT_DATE_FORMAT.format(time2);
        if (string == null) {
            DateFormatUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static String someTimeAgoMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days.ago", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes.ago", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours.ago", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months.ago", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks.ago", n);
            }
        }
        return CommonBundle.message("date.format.n.years.ago", n);
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.in.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.in.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.in.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.in.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.in.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.in.n.years", n);
    }

    private static SyncDateFormat[] getDateTimeFormats() {
        DateFormat[] formats = new DateFormat[4];
        boolean loaded = false;
        if (JnaLoader.isLoaded() || SystemInfo.isXWindow) {
            try {
                if (SystemInfo.isWin7OrNewer) {
                    loaded = DateFormatUtil.getWindowsFormats(formats);
                } else if (SystemInfo.isMac) {
                    loaded = DateFormatUtil.getMacFormats(formats);
                } else if (SystemInfo.isUnix) {
                    loaded = DateFormatUtil.getUnixFormats(formats);
                }
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        if (!loaded) {
            formats[0] = DateFormat.getDateInstance(3);
            formats[1] = DateFormat.getTimeInstance(3);
            formats[2] = DateFormat.getTimeInstance(2);
            formats[3] = DateFormat.getDateTimeInstance(3, 3);
        }
        SyncDateFormat[] synced = new SyncDateFormat[4];
        for (int i2 = 0; i2 < formats.length; ++i2) {
            synced[i2] = new SyncDateFormat(formats[i2]);
        }
        return synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getMacFormats(DateFormat[] formats) {
        boolean MacFormatterNoStyle = false;
        boolean MacFormatterShortStyle = true;
        int MacFormatterMediumStyle = 2;
        int MacFormatterBehavior_10_4 = 1040;
        ID autoReleasePool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
        try {
            ID dateFormatter = Foundation.invoke("NSDateFormatter", "new", new Object[0]);
            Foundation.invoke(dateFormatter, Foundation.createSelector("setFormatterBehavior:"), 1040);
            formats[0] = DateFormatUtil.invokeFormatter(dateFormatter, 0, 1);
            formats[1] = DateFormatUtil.invokeFormatter(dateFormatter, 1, 0);
            formats[2] = DateFormatUtil.invokeFormatter(dateFormatter, 2, 0);
            formats[3] = DateFormatUtil.invokeFormatter(dateFormatter, 1, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            Foundation.invoke(autoReleasePool, Foundation.createSelector("release"), new Object[0]);
        }
    }

    private static DateFormat invokeFormatter(ID dateFormatter, int timeStyle, int dateStyle) {
        Foundation.invoke(dateFormatter, Foundation.createSelector("setTimeStyle:"), timeStyle);
        Foundation.invoke(dateFormatter, Foundation.createSelector("setDateStyle:"), dateStyle);
        String format = Foundation.toStringViaUTF8(Foundation.invoke(dateFormatter, Foundation.createSelector("dateFormat"), new Object[0]));
        assert (format != null);
        return new SimpleDateFormat(format.trim());
    }

    private static boolean getUnixFormats(DateFormat[] formats) {
        String localeStr = System.getenv("LC_TIME");
        if (localeStr == null) {
            return false;
        }
        int p2 = (localeStr = localeStr.trim()).indexOf(46);
        if (p2 > 0) {
            localeStr = localeStr.substring(0, p2);
        }
        if ((p2 = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p2);
        }
        Locale locale = (p2 = localeStr.indexOf(95)) < 0 ? new Locale(localeStr) : new Locale(localeStr.substring(0, p2), localeStr.substring(p2 + 1));
        formats[0] = DateFormat.getDateInstance(3, locale);
        formats[1] = DateFormat.getTimeInstance(3, locale);
        formats[2] = DateFormat.getTimeInstance(2, locale);
        formats[3] = DateFormat.getDateTimeInstance(3, 3, locale);
        return true;
    }

    private static boolean getWindowsFormats(DateFormat[] formats) {
        Kernel32 kernel32 = Native.loadLibrary("Kernel32", Kernel32.class);
        int dataSize = 128;
        Memory data2 = new Memory(dataSize);
        int rv = kernel32.GetLocaleInfoEx(Kernel32.LOCALE_NAME_USER_DEFAULT, 31, data2, dataSize);
        assert (rv > 1) : kernel32.GetLastError();
        String shortDate = DateFormatUtil.fixWindowsFormat(new String(data2.getCharArray(0L, rv - 1)));
        rv = kernel32.GetLocaleInfoEx(Kernel32.LOCALE_NAME_USER_DEFAULT, 121, data2, dataSize);
        assert (rv > 1) : kernel32.GetLastError();
        String shortTime = DateFormatUtil.fixWindowsFormat(new String(data2.getCharArray(0L, rv - 1)));
        rv = kernel32.GetLocaleInfoEx(Kernel32.LOCALE_NAME_USER_DEFAULT, 4099, data2, dataSize);
        assert (rv > 1) : kernel32.GetLastError();
        String mediumTime = DateFormatUtil.fixWindowsFormat(new String(data2.getCharArray(0L, rv - 1)));
        formats[0] = new SimpleDateFormat(shortDate);
        formats[1] = new SimpleDateFormat(shortTime);
        formats[2] = new SimpleDateFormat(mediumTime);
        formats[3] = new SimpleDateFormat(shortDate + " " + shortTime);
        return true;
    }

    private static String fixWindowsFormat(String format) {
        format = format.replaceAll("g+", "G");
        format = StringUtil.replace(format, "tt", "a");
        return format;
    }

    static {
        SyncDateFormat[] formats = DateFormatUtil.getDateTimeFormats();
        DATE_FORMAT = formats[0];
        TIME_FORMAT = formats[1];
        TIME_WITH_SECONDS_FORMAT = formats[2];
        DATE_TIME_FORMAT = formats[3];
        ABOUT_DATE_FORMAT = new SyncDateFormat(DateFormat.getDateInstance(1, Locale.US));
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        ISO8601_FORMAT = new SyncDateFormat(iso8601);
        DENOMINATORS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
        PERIODS = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endDate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/DateFormatUtil";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 16: 
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/DateFormatUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeWithSecondsFormat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeFormat";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIso8601Format";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTimeWithSeconds";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPrettyDate";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateTime";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPrettyDateTime";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doFormatPretty";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrequency";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBetweenDates";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAboutDialogDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDifferenceInDays";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatTime";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatTimeWithSeconds";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDateTime";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "formatAboutDialogDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final String LOCALE_NAME_USER_DEFAULT = null;
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, Pointer var3, int var4);

        public int GetLastError();
    }

    private static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

