/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownUtil {
    private MarkdownUtil() {
    }

    public static void replaceHeaders(@NotNull List<String> lines) {
        if (lines == null) {
            MarkdownUtil.$$$reportNull$$$0(0);
        }
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            int endInd;
            int ind;
            String line = lines.get(i2);
            for (ind = 0; ind < line.length() && line.charAt(ind) == '#'; ++ind) {
            }
            if (ind >= line.length() || line.charAt(ind) != ' ' || 0 >= ind || ind > 9) continue;
            for (endInd = line.length() - 1; endInd >= 0 && line.charAt(endInd) == '#'; --endInd) {
            }
            line = line.substring(ind + 1, endInd + 1);
            line = "<h" + ind + ">" + line + "</h" + ind + ">";
            lines.set(i2, line);
        }
    }

    public static void removeImages(@NotNull List<String> lines) {
        if (lines == null) {
            MarkdownUtil.$$$reportNull$$$0(1);
        }
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            String newText = MarkdownUtil.removeAllImages(lines.get(i2));
            lines.set(i2, newText);
        }
    }

    @NotNull
    private static String removeAllImages(@NotNull String text2) {
        TextRange range;
        if (text2 == null) {
            MarkdownUtil.$$$reportNull$$$0(2);
        }
        int n = text2.length();
        ArrayList<TextRange> intervals = null;
        for (int i2 = 0; i2 < n; ++i2) {
            int imageEndIndex = MarkdownUtil.findImageEndIndexInclusive(text2, i2);
            if (imageEndIndex == -1) continue;
            TextRange linkRange = MarkdownUtil.findEnclosingLink(text2, i2, imageEndIndex);
            if (intervals == null) {
                intervals = new ArrayList<TextRange>(1);
            }
            range = linkRange != null ? linkRange : new TextRange(i2, imageEndIndex);
            intervals.add(range);
            i2 = range.getEndOffset();
        }
        if (intervals == null) {
            String string = text2;
            if (string == null) {
                MarkdownUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder(text2);
        for (int intervalInd = intervals.size() - 1; intervalInd >= 0; --intervalInd) {
            range = (TextRange)intervals.get(intervalInd);
            buf.delete(range.getStartOffset(), range.getEndOffset() + 1);
        }
        String string = buf.toString();
        if (string == null) {
            MarkdownUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static int findImageEndIndexInclusive(@NotNull String text2, int imageStartIndex) {
        if (text2 == null) {
            MarkdownUtil.$$$reportNull$$$0(5);
        }
        int n = text2.length();
        if (text2.charAt(imageStartIndex) == '!' && imageStartIndex + 1 < n && text2.charAt(imageStartIndex + 1) == '[') {
            int i2;
            for (i2 = imageStartIndex + 2; i2 < n && text2.charAt(i2) != ']'; ++i2) {
            }
            if (i2 < n && i2 + 1 < n && text2.charAt(i2 + 1) == '(') {
                i2 += 2;
                while (i2 < n && text2.charAt(i2) != ')') {
                    ++i2;
                }
                if (i2 < n) {
                    return i2;
                }
            }
        }
        return -1;
    }

    @Nullable
    private static TextRange findEnclosingLink(@NotNull String text2, int imageStartIndInc, int imageEndIndInc) {
        int linkStartIndInc;
        if (text2 == null) {
            MarkdownUtil.$$$reportNull$$$0(6);
        }
        if ((linkStartIndInc = imageStartIndInc - 1) >= 0 && text2.charAt(linkStartIndInc) == '[') {
            int n = text2.length();
            int i2 = imageEndIndInc + 1;
            if (text2.charAt(i2) == ']' && i2 + 1 < n && text2.charAt(i2 + 1) == '(') {
                i2 += 2;
                while (i2 < n && text2.charAt(i2) != ')') {
                    ++i2;
                }
                if (i2 < n) {
                    return new TextRange(linkStartIndInc, i2);
                }
            }
        }
        return null;
    }

    public static void replaceCodeBlock(@NotNull List<String> lines) {
        if (lines == null) {
            MarkdownUtil.$$$reportNull$$$0(7);
        }
        new CodeBlockProcessor(lines).process();
    }

    public static void generateLists(@NotNull List<String> lines) {
        if (lines == null) {
            MarkdownUtil.$$$reportNull$$$0(8);
        }
        new ListItemProcessor(lines).process();
    }

    @Nullable
    private static ListItem toListItem(@NotNull String line) {
        int i2;
        if (line == null) {
            MarkdownUtil.$$$reportNull$$$0(9);
        }
        if ((line = StringUtil.trimLeading(line)).length() >= 2) {
            char firstChar = line.charAt(0);
            char secondChar = line.charAt(1);
            if ((firstChar == '*' || firstChar == '+' || firstChar == '-') && Character.isWhitespace(secondChar)) {
                return new ListItem(true, StringUtil.trimLeading(line.substring(1)));
            }
        }
        for (i2 = 0; i2 < line.length() && Character.isDigit(line.charAt(i2)); ++i2) {
        }
        if (i2 > 0 && i2 < line.length() - 1 && line.charAt(i2) == '.' && Character.isWhitespace(line.charAt(i2 + 1))) {
            return new ListItem(false, StringUtil.trimLeading(line.substring(i2 + 1)));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/MarkdownUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/MarkdownUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllImages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceHeaders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeImages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeAllImages";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findImageEndIndexInclusive";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLink";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceCodeBlock";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateLists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toListItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ListItem {
        private final boolean myUnordered;
        private final String myBody;

        private ListItem(boolean unordered, @NotNull String body2) {
            if (body2 == null) {
                ListItem.$$$reportNull$$$0(0);
            }
            this.myUnordered = unordered;
            this.myBody = body2;
        }

        private boolean isUnordered() {
            return this.myUnordered;
        }

        @NotNull
        private String getBody() {
            String string = this.myBody;
            if (string == null) {
                ListItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/text/MarkdownUtil$ListItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/text/MarkdownUtil$ListItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ListItemProcessor {
        private final List<String> myLines;
        private boolean myInsideBlockQuote;
        private ListItem myFirstListItem;
        private int myLastListItemLineInd;

        private ListItemProcessor(@NotNull List<String> lines) {
            if (lines == null) {
                ListItemProcessor.$$$reportNull$$$0(0);
            }
            this.myInsideBlockQuote = false;
            this.myFirstListItem = null;
            this.myLastListItemLineInd = -1;
            this.myLines = lines;
        }

        public void process() {
            for (int i2 = 0; i2 < this.myLines.size(); ++i2) {
                String line = this.myLines.get(i2);
                if (line.startsWith("```")) {
                    boolean bl = this.myInsideBlockQuote = !this.myInsideBlockQuote;
                }
                if (this.myInsideBlockQuote) continue;
                this.handle(i2, line);
            }
            this.finishLastListItem(true);
        }

        private void handle(int ind, @NotNull String line) {
            ListItem listItem;
            if (line == null) {
                ListItemProcessor.$$$reportNull$$$0(1);
            }
            if ((listItem = MarkdownUtil.toListItem(line)) != null) {
                this.finishLastListItem(false);
                String out = "<li>" + listItem.getBody();
                if (this.myFirstListItem == null) {
                    this.myFirstListItem = listItem;
                    out = listItem.isUnordered() ? "<ul>" + out : "<ol>" + out;
                }
                this.myLines.set(ind, out);
                this.myLastListItemLineInd = ind;
            } else if (this.myFirstListItem != null && !line.isEmpty() && !StringUtil.isEmptyOrSpaces(line)) {
                if (ind - 1 >= 0 && StringUtil.isEmptyOrSpaces(this.myLines.get(ind - 1)) && !Character.isWhitespace(line.charAt(0))) {
                    this.finishLastListItem(true);
                } else {
                    String m = StringUtil.trimLeading(line);
                    this.myLines.set(ind, m);
                    this.myLastListItemLineInd = ind;
                }
            }
        }

        private void finishLastListItem(boolean finishList) {
            if (this.myLastListItemLineInd != -1) {
                String l = this.myLines.get(this.myLastListItemLineInd);
                l = l + "</li>";
                if (finishList) {
                    l = this.myFirstListItem.isUnordered() ? l + "</ul>" : l + "</ol>";
                    this.myFirstListItem = null;
                }
                this.myLines.set(this.myLastListItemLineInd, l);
                this.myLastListItemLineInd = -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/text/MarkdownUtil$ListItemProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CodeBlockProcessor {
        private static final String START_TAGS = "<pre><code>";
        private static final String END_TAGS = "</code></pre>";
        private final List<String> myLines;
        private boolean myGlobalCodeBlockStarted;
        private boolean myCodeBlockStarted;

        private CodeBlockProcessor(@NotNull List<String> lines) {
            if (lines == null) {
                CodeBlockProcessor.$$$reportNull$$$0(0);
            }
            this.myGlobalCodeBlockStarted = false;
            this.myCodeBlockStarted = false;
            this.myLines = lines;
        }

        public void process() {
            for (int i2 = 0; i2 < this.myLines.size(); ++i2) {
                String line = this.myLines.get(i2);
                if (line.startsWith("```")) {
                    this.finishCodeBlock(i2 - 1);
                    this.myGlobalCodeBlockStarted = !this.myGlobalCodeBlockStarted;
                    String out = this.myGlobalCodeBlockStarted ? START_TAGS : END_TAGS;
                    this.myLines.set(i2, out);
                    continue;
                }
                if (this.myGlobalCodeBlockStarted) continue;
                this.handleLocalCodeBlock(i2, line);
            }
            this.finishCodeBlock(this.myLines.size() - 1);
        }

        private void handleLocalCodeBlock(int ind, @NotNull String line) {
            if (line == null) {
                CodeBlockProcessor.$$$reportNull$$$0(1);
            }
            boolean codeBlock = false;
            if (line.startsWith("    ")) {
                line = line.substring(4);
                codeBlock = true;
            } else if (line.startsWith("\t")) {
                line = line.substring(1);
                codeBlock = true;
            }
            if (!this.myCodeBlockStarted) {
                if (codeBlock) {
                    this.myCodeBlockStarted = true;
                    this.myLines.set(ind, START_TAGS + line);
                }
            } else if (codeBlock) {
                this.myLines.set(ind, line);
            } else {
                this.finishCodeBlock(ind - 1);
            }
        }

        private void finishCodeBlock(int lastCodeBlockLineInd) {
            if (this.myCodeBlockStarted) {
                this.myLines.set(lastCodeBlockLineInd, this.myLines.get(lastCodeBlockLineInd) + END_TAGS);
                this.myCodeBlockStarted = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/text/MarkdownUtil$CodeBlockProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleLocalCodeBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

