/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import javax.swing.JPanel;
import org.intellij.lang.annotations.JdkConstants;

public class MultiRowFlowPanel
extends JPanel {
    private final int maximumWidth;
    private int myForcedWidth;

    public MultiRowFlowPanel(@JdkConstants.FlowLayoutAlignment int align, int hGap, int vGap) {
        super(new FlowLayout(align, hGap, vGap));
        this.maximumWidth = GraphicsEnvironment.isHeadless() ? 400 : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().width / 2;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.calculateSize(this.getMaxRowWidth());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.calculateSize(this.getMaxRowWidth());
    }

    private int getMaxRowWidth() {
        if (this.myForcedWidth > 0) {
            return this.myForcedWidth;
        }
        int result2 = this.getSize().width;
        if (result2 == 0) {
            result2 = Math.min(super.getPreferredSize().width, this.maximumWidth);
        }
        return result2;
    }

    public void setForcedWidth(int forcedWidth) {
        this.myForcedWidth = forcedWidth;
    }

    private Dimension calculateSize(int maxRowWidth) {
        FlowLayout layout = (FlowLayout)this.getLayout();
        int height = 0;
        int currentRowWidth = 0;
        int currentRowHeight = 0;
        int count2 = this.getComponentCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            Component comp2 = this.getComponent(i2);
            Dimension bounds = comp2.getPreferredSize();
            if (!comp2.isVisible()) continue;
            currentRowHeight = Math.max(currentRowHeight, bounds.height);
            if (currentRowWidth + layout.getHgap() + bounds.width <= maxRowWidth) {
                if (bounds.width == 0) continue;
                currentRowWidth += bounds.width + layout.getHgap();
                continue;
            }
            height += currentRowHeight + layout.getVgap();
            currentRowWidth = bounds.width;
            currentRowHeight = bounds.height;
        }
        return new Dimension(maxRowWidth, height + currentRowHeight + 2 * layout.getVgap());
    }
}

