/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.tree.TreeModelListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements Disposable,
TreeModel {
    protected final TreeModelListenerList listeners = new TreeModelListenerList();
    protected volatile boolean disposed;

    @Override
    public void dispose() {
        this.disposed = true;
        this.listeners.clear();
    }

    protected void treeStructureChanged(TreePath path2, int[] indices, Object[] children2) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeStructureChanged(new TreeModelEvent((Object)this, path2, indices, children2));
        }
    }

    protected void treeNodesChanged(TreePath path2, int[] indices, Object[] children2) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeNodesChanged(new TreeModelEvent((Object)this, path2, indices, children2));
        }
    }

    protected void treeNodesInserted(TreePath path2, int[] indices, Object[] children2) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeNodesInserted(new TreeModelEvent((Object)this, path2, indices, children2));
        }
    }

    protected void treeNodesRemoved(TreePath path2, int[] indices, Object[] children2) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeNodesRemoved(new TreeModelEvent((Object)this, path2, indices, children2));
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (!this.disposed) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        if (!this.disposed) {
            this.listeners.remove(listener);
        }
    }
}

