/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import org.jetbrains.annotations.NonNls;

public class XmlFileHeader {
    public static final XmlFileHeader EMPTY = new XmlFileHeader(null, null, null, null);
    private final String myRootTagLocalName;
    private final String myRootTagNamespace;
    private final String myPublicId;
    private final String mySystemId;

    public XmlFileHeader(String rootTagLocalName, String rootTagNamespace, String publicId, String systemId) {
        this.myPublicId = publicId;
        this.myRootTagLocalName = rootTagLocalName;
        this.myRootTagNamespace = rootTagNamespace;
        this.mySystemId = systemId;
    }

    public String getPublicId() {
        return this.myPublicId;
    }

    public String getRootTagLocalName() {
        return this.myRootTagLocalName;
    }

    public String getRootTagNamespace() {
        return this.myRootTagNamespace;
    }

    public String getSystemId() {
        return this.mySystemId;
    }

    @NonNls
    public String toString() {
        return "XmlFileHeader: name=" + this.myRootTagLocalName + "; namespace=" + this.myRootTagNamespace + "; publicId=" + this.myPublicId + "; systemId=" + this.mySystemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlFileHeader)) {
            return false;
        }
        XmlFileHeader header2 = (XmlFileHeader)o;
        if (this.myPublicId != null ? !this.myPublicId.equals(header2.myPublicId) : header2.myPublicId != null) {
            return false;
        }
        if (this.myRootTagLocalName != null ? !this.myRootTagLocalName.equals(header2.myRootTagLocalName) : header2.myRootTagLocalName != null) {
            return false;
        }
        if (this.myRootTagNamespace != null ? !this.myRootTagNamespace.equals(header2.myRootTagNamespace) : header2.myRootTagNamespace != null) {
            return false;
        }
        return !(this.mySystemId != null ? !this.mySystemId.equals(header2.mySystemId) : header2.mySystemId != null);
    }

    public int hashCode() {
        int result2 = this.myRootTagLocalName != null ? this.myRootTagLocalName.hashCode() : 0;
        result2 = 31 * result2 + (this.myRootTagNamespace != null ? this.myRootTagNamespace.hashCode() : 0);
        result2 = 31 * result2 + (this.myPublicId != null ? this.myPublicId.hashCode() : 0);
        result2 = 31 * result2 + (this.mySystemId != null ? this.mySystemId.hashCode() : 0);
        return result2;
    }
}

