/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.Nullable;

public class HtmlXmlExtension
extends DefaultXmlExtension {
    @Override
    public boolean isAvailable(PsiFile file2) {
        return file2.getFileType() == HtmlFileType.INSTANCE;
    }

    @Override
    @Nullable
    public String[][] getNamespacesFromDocument(XmlDocument parent2, boolean declarationsExist) {
        String[][] namespaces = super.getNamespacesFromDocument(parent2, false);
        if (namespaces == null || !HtmlUtil.isHtml5Document(parent2)) {
            return namespaces;
        }
        for (String[] namespace : namespaces) {
            if (!"xlink".equals(namespace[0])) continue;
            return namespaces;
        }
        String[][] newNamespaces = new String[namespaces.length + 1][2];
        System.arraycopy(namespaces, 0, newNamespaces, 0, namespaces.length);
        newNamespaces[namespaces.length] = new String[]{"xlink", "http://www.w3.org/1999/xlink"};
        return newNamespaces;
    }
}

