/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.util.XmlResourceResolver;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ErrorReporter {
    protected final Set<String> ourErrorsSet = new HashSet<String>();
    protected final ValidateXmlActionHandler myHandler;

    public ErrorReporter(ValidateXmlActionHandler handler2) {
        this.myHandler = handler2;
    }

    public abstract void processError(SAXParseException var1, ValidateXmlActionHandler.ProblemType var2) throws SAXException;

    public boolean filterValidationException(Exception ex) {
        if (ex instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)ex;
        }
        if (ex instanceof XmlResourceResolver.IgnoredResourceException) {
            throw (XmlResourceResolver.IgnoredResourceException)ex;
        }
        return ex instanceof FileNotFoundException || ex instanceof MalformedURLException || ex instanceof NoRouteToHostException || ex instanceof SocketTimeoutException || ex instanceof UnknownHostException || ex instanceof ConnectException;
    }

    public void startProcessing() {
        this.myHandler.doParse();
    }

    public boolean isStopOnUndeclaredResource() {
        return false;
    }

    public boolean isUniqueProblem(SAXParseException e) {
        String error = this.myHandler.buildMessageString(e);
        if (this.ourErrorsSet.contains(error)) {
            return false;
        }
        this.ourErrorsSet.add(error);
        return true;
    }
}

