/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodUtil {
    private static final int MAX_OVERRIDDEN_METHOD_SEARCH = 20;

    @Nullable
    public static Stream<PsiMethod> getOverridingMethodsIfCheapEnough(@NotNull PsiMethod method, @Nullable GlobalSearchScope searchScope, @NotNull Predicate<PsiMethod> preFilter) {
        if (method == null) {
            JavaOverridingMethodUtil.$$$reportNull$$$0(0);
        }
        if (preFilter == null) {
            JavaOverridingMethodUtil.$$$reportNull$$$0(1);
        }
        Project project = method.getProject();
        String name = method.getName();
        SearchScope useScope = method.getUseScope();
        GlobalSearchScope effectiveSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project);
        if (searchScope != null) {
            effectiveSearchScope = effectiveSearchScope.intersectWith(searchScope);
        }
        ArrayList methods2 = ContainerUtil.newArrayList();
        if (!StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, name, project, new JavaSourceFilterScope(effectiveSearchScope), PsiMethod.class, m -> {
            if (method == null) {
                JavaOverridingMethodUtil.$$$reportNull$$$0(5);
            }
            if (preFilter == null) {
                JavaOverridingMethodUtil.$$$reportNull$$$0(6);
            }
            ProgressManager.checkCanceled();
            if (m == method) {
                return true;
            }
            if (!preFilter.test((PsiMethod)m)) {
                return true;
            }
            methods2.add(m);
            return methods2.size() <= 20;
        })) {
            return null;
        }
        return methods2.stream().filter(candidate2 -> {
            if (method == null) {
                JavaOverridingMethodUtil.$$$reportNull$$$0(4);
            }
            return PsiSuperMethodUtil.isSuperMethod(candidate2, method);
        });
    }

    public static boolean containsAnnotationWithName(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String shortAnnotationName) {
        PsiModifierList list2;
        if (modifierListOwner == null) {
            JavaOverridingMethodUtil.$$$reportNull$$$0(2);
        }
        if (shortAnnotationName == null) {
            JavaOverridingMethodUtil.$$$reportNull$$$0(3);
        }
        if ((list2 = modifierListOwner.getModifierList()) != null) {
            for (PsiAnnotation annotation2 : list2.getAnnotations()) {
                PsiJavaCodeReferenceElement ref = annotation2.getNameReferenceElement();
                if (ref == null || !shortAnnotationName.equals(ref.getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortAnnotationName";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/JavaOverridingMethodUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOverridingMethodsIfCheapEnough";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "containsAnnotationWithName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getOverridingMethodsIfCheapEnough$1";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getOverridingMethodsIfCheapEnough$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

