/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class ForLoopThatDoesntUseLoopVariableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.display.name", new Object[0]);
        if (string == null) {
            ForLoopThatDoesntUseLoopVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        boolean condition = (Boolean)infos2[0];
        boolean update = (Boolean)infos2[1];
        if (condition && update) {
            String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.both.condition.and.update", new Object[0]);
            if (string == null) {
                ForLoopThatDoesntUseLoopVariableInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (condition) {
            String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.condition", new Object[0]);
            if (string == null) {
                ForLoopThatDoesntUseLoopVariableInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.update", new Object[0]);
        if (string == null) {
            ForLoopThatDoesntUseLoopVariableInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopThatDoesntUseLoopVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ForLoopThatDoesntUseLoopVariableVisitor
    extends BaseInspectionVisitor {
        private ForLoopThatDoesntUseLoopVariableVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement2) {
            boolean notUsedInUpdate;
            if (statement2 == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement2);
            PsiLocalVariable variable2 = ForLoopThatDoesntUseLoopVariableVisitor.extractInitializerVariable(statement2);
            if (variable2 == null) {
                return;
            }
            boolean notUsedInCondition = !ForLoopThatDoesntUseLoopVariableVisitor.conditionUsesVariable(statement2, variable2);
            boolean bl = notUsedInUpdate = !ForLoopThatDoesntUseLoopVariableVisitor.updateUsesVariable(statement2, variable2);
            if (notUsedInCondition || notUsedInUpdate) {
                if (!notUsedInCondition && ForLoopThatDoesntUseLoopVariableVisitor.isDeclarationUsedAsBound(statement2, variable2)) {
                    return;
                }
                this.registerStatementError(statement2, notUsedInCondition, notUsedInUpdate);
            }
        }

        private static boolean isDeclarationUsedAsBound(PsiForStatement statement2, PsiLocalVariable boundVar) {
            PsiBinaryExpression condition = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(statement2.getCondition()), PsiBinaryExpression.class);
            if (condition == null || !ComparisonUtils.isComparisonOperation(condition.getOperationTokenType())) {
                return false;
            }
            PsiExpression otherOperand = null;
            if (ExpressionUtils.isReferenceTo(condition.getLOperand(), boundVar)) {
                otherOperand = condition.getROperand();
            } else if (ExpressionUtils.isReferenceTo(condition.getROperand(), boundVar)) {
                otherOperand = condition.getLOperand();
            }
            if (otherOperand == null) {
                return false;
            }
            PsiReferenceExpression ref = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(otherOperand), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiVariable indexVar = ObjectUtils.tryCast(ref.resolve(), PsiVariable.class);
            if (indexVar == null) {
                return false;
            }
            PsiStatement update = statement2.getUpdate();
            return VariableAccessUtils.variableIsIncremented(indexVar, update) || VariableAccessUtils.variableIsDecremented(indexVar, update);
        }

        private static PsiLocalVariable extractInitializerVariable(PsiForStatement statement2) {
            PsiDeclarationStatement declaration = ObjectUtils.tryCast(statement2.getInitialization(), PsiDeclarationStatement.class);
            if (declaration == null) {
                return null;
            }
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            return ObjectUtils.tryCast(declaredElements[0], PsiLocalVariable.class);
        }

        private static boolean conditionUsesVariable(PsiForStatement statement2, PsiLocalVariable variable2) {
            PsiExpression condition = statement2.getCondition();
            return condition == null || VariableAccessUtils.variableIsUsed(variable2, condition);
        }

        private static boolean updateUsesVariable(PsiForStatement statement2, PsiLocalVariable variable2) {
            PsiStatement update = statement2.getUpdate();
            return update == null || VariableAccessUtils.variableIsUsed(variable2, update);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection$ForLoopThatDoesntUseLoopVariableVisitor", "visitForStatement"));
        }
    }
}

