/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreResultOfCallInspectionBase
extends BaseInspection {
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterCount(1);
    private static final CallMatcher COLLECTOR_TO_COLLECTION = CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1);
    public boolean m_reportAllNonLibraryCalls = false;
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(true, "callCheckString").add("java.io.File", ".*").add("java.io.InputStream", "read|skip|available|markSupported").add("java.io.Reader", "read|skip|ready|markSupported").add("java.lang.Boolean", ".*").add("java.lang.Byte", ".*").add("java.lang.Character", ".*").add("java.lang.Double", ".*").add("java.lang.Float", ".*").add("java.lang.Integer", ".*").add("java.lang.Long", ".*").add("java.lang.Math", ".*").add("java.lang.Object", "equals|hashCode|toString").add("java.lang.Short", ".*").add("java.lang.StrictMath", ".*").add("java.lang.String", ".*").add("java.math.BigInteger", ".*").add("java.math.BigDecimal", ".*").add("java.net.InetAddress", ".*").add("java.net.URI", ".*").add("java.util.Arrays", ".*").add("java.util.List", "of").add("java.util.Set", "of").add("java.util.Map", "of|ofEntries|entry").add("java.util.Collections", "(?!addAll).*").add("java.util.UUID", ".*").add("java.util.regex.Matcher", "pattern|toMatchResult|start|end|group|groupCount|matches|find|lookingAt|quoteReplacement|replaceAll|replaceFirst|regionStart|regionEnd|hasTransparentBounds|hasAnchoringBounds|hitEnd|requireEnd").add("java.util.regex.Pattern", ".*").add("java.util.stream.BaseStream", ".*").finishDefault();

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ResultOfMethodCallIgnored" == null) {
            IgnoreResultOfCallInspectionBase.$$$reportNull$$$0(0);
        }
        return "ResultOfMethodCallIgnored";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            IgnoreResultOfCallInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass containingClass = (PsiClass)infos2[0];
        String className2 = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className2);
        if (string == null) {
            IgnoreResultOfCallInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            IgnoreResultOfCallInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            IgnoreResultOfCallInspectionBase.$$$reportNull$$$0(4);
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement resolve2;
            if (PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType(expression2)) && (resolve2 = expression2.resolve()) instanceof PsiMethod) {
                this.visitCalledExpression(expression2, (PsiMethod)resolve2, null);
            }
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiExpressionStatement || parent2 instanceof PsiLambdaExpression && PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)parent2))) {
                PsiMethod method = expression2.resolveMethod();
                if (method == null || method.isConstructor()) {
                    return;
                }
                this.visitCalledExpression(expression2, method, parent2);
            }
        }

        private void visitCalledExpression(PsiExpression call2, PsiMethod method, @Nullable PsiElement errorContainer) {
            PsiElement owner;
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals(returnType)) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            if (errorContainer != null && PsiUtilCore.hasErrorElementChild(errorContainer)) {
                return;
            }
            if (PropertyUtil.isSimpleGetter(method)) {
                this.registerMethodCallOrRefError(call2, aClass2);
                return;
            }
            if (IgnoreResultOfCallInspectionBase.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass2)) {
                this.registerMethodCallOrRefError(call2, aClass2);
                return;
            }
            if (this.isPureMethod(method)) {
                this.registerMethodCallOrRefError(call2, aClass2);
                return;
            }
            PsiAnnotation annotation2 = this.findAnnotationInTree(method, null, Collections.singleton("javax.annotation.CheckReturnValue"));
            if (annotation2 != null && this.findAnnotationInTree(method, owner = (PsiElement)((Object)annotation2.getOwner()), Collections.singleton("com.google.errorprone.annotations.CanIgnoreReturnValue")) != null) {
                return;
            }
            if (!IgnoreResultOfCallInspectionBase.this.myMethodMatcher.matches(method) && annotation2 == null) {
                return;
            }
            if (this.isHardcodedException(call2)) {
                return;
            }
            this.registerMethodCallOrRefError(call2, aClass2);
        }

        private boolean isHardcodedException(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression2;
            if (STREAM_COLLECT.test(call2)) {
                PsiExpression body2;
                PsiLambdaExpression lambda2;
                PsiMethodCallExpression collector2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(call2.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                if (COLLECTOR_TO_COLLECTION.test(collector2) && (lambda2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(collector2.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class)) != null && (body2 = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()))) instanceof PsiReferenceExpression && ((PsiReferenceExpression)body2).resolve() instanceof PsiVariable) {
                    return true;
                }
            }
            return false;
        }

        private boolean isPureMethod(PsiMethod method) {
            PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method);
            if (anno == null) {
                return false;
            }
            boolean honorInferred = Registry.is("ide.ignore.call.result.inspection.honor.inferred.pure");
            if (!honorInferred && AnnotationUtil.isInferredAnnotation(anno)) {
                return false;
            }
            return Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue(anno, "pure")) && !SideEffectChecker.mayHaveExceptionalSideEffect(method);
        }

        private void registerMethodCallOrRefError(PsiExpression call2, PsiClass aClass2) {
            if (call2 instanceof PsiMethodCallExpression) {
                this.registerMethodCallError((PsiMethodCallExpression)call2, aClass2);
            } else if (call2 instanceof PsiMethodReferenceExpression) {
                this.registerError((PsiElement)ObjectUtils.notNull(((PsiMethodReferenceExpression)call2).getReferenceNameElement(), call2), aClass2);
            }
        }

        @Nullable
        private PsiAnnotation findAnnotationInTree(PsiElement element, @Nullable PsiElement stop, @NotNull Set<String> fqAnnotationNames) {
            if (fqAnnotationNames == null) {
                IgnoreResultOfCallVisitor.$$$reportNull$$$0(0);
            }
            while (element != null) {
                PsiModifierListOwner modifierListOwner;
                PsiAnnotation annotation2;
                if (element == stop) {
                    return null;
                }
                if (element instanceof PsiModifierListOwner && (annotation2 = AnnotationUtil.findAnnotationInHierarchy(modifierListOwner = (PsiModifierListOwner)element, fqAnnotationNames)) != null) {
                    return annotation2;
                }
                if (element instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)element;
                    String packageName = classOwner.getPackageName();
                    PsiPackage aPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
                    if (aPackage == null) {
                        return null;
                    }
                    PsiAnnotation annotation3 = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, fqAnnotationNames);
                    if (annotation3 != null) {
                        VirtualFile currentClassRoot;
                        ProjectFileIndex projectFileIndex;
                        VirtualFile annotationClassRoot;
                        VirtualFile annotationFile = PsiUtilCore.getVirtualFile(annotation3);
                        VirtualFile currentFile = classOwner.getVirtualFile();
                        if (annotationFile != null && currentFile != null && !Objects.equals(annotationClassRoot = (projectFileIndex = ProjectFileIndex.getInstance(element.getProject())).getClassRootForFile(annotationFile), currentClassRoot = projectFileIndex.getClassRootForFile(currentFile))) {
                            return null;
                        }
                    }
                    return annotation3;
                }
                element = element.getContext();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqAnnotationNames", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase$IgnoreResultOfCallVisitor", "findAnnotationInTree"));
        }
    }
}

