/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class MismatchedArrayReadWriteInspection
extends BaseInspection {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("MismatchedReadAndWriteOfArray" == null) {
            MismatchedArrayReadWriteInspection.$$$reportNull$$$0(0);
        }
        return "MismatchedReadAndWriteOfArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.display.name", new Object[0]);
        if (string == null) {
            MismatchedArrayReadWriteInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        boolean written = (Boolean)infos2[0];
        if (written) {
            String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.write.not.read", new Object[0]);
            if (string == null) {
                MismatchedArrayReadWriteInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.read.not.write", new Object[0]);
        if (string == null) {
            MismatchedArrayReadWriteInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedArrayReadWriteVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MismatchedArrayReadWriteVisitor
    extends BaseInspectionVisitor {
        private MismatchedArrayReadWriteVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MismatchedArrayReadWriteVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!MismatchedArrayReadWriteVisitor.shouldCheckVariable(field, containingClass)) {
                return;
            }
            ArrayReadWriteVisitor visitor2 = new ArrayReadWriteVisitor(field, !MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(field.getInitializer()));
            containingClass.accept(visitor2);
            boolean written = visitor2.isWritten();
            if (!visitor2.isReferenced() || written == visitor2.isRead() || UnusedSymbolUtil.isImplicitWrite(field)) {
                return;
            }
            this.registerFieldError(field, written);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable2) {
            if (variable2 == null) {
                MismatchedArrayReadWriteVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable2);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class);
            if (!MismatchedArrayReadWriteVisitor.shouldCheckVariable(variable2, codeBlock)) {
                return;
            }
            ArrayReadWriteVisitor visitor2 = new ArrayReadWriteVisitor(variable2, !MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(variable2.getInitializer()));
            codeBlock.accept(visitor2);
            boolean written = visitor2.isWritten();
            if (!visitor2.isReferenced() || written == visitor2.isRead()) {
                return;
            }
            this.registerVariableError(variable2, written);
        }

        private static boolean shouldCheckVariable(PsiVariable variable2, PsiElement context) {
            return context != null && variable2.getType().getArrayDimensions() != 0 && !MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(variable2.getInitializer());
        }

        static boolean mayBeAccessedElsewhere(PsiExpression expression2) {
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return false;
            }
            if (expression2 instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)expression2;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(arrayInitializer);
            }
            if (expression2 instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression2;
                for (PsiExpression initializer2 : arrayInitializerExpression.getInitializers()) {
                    if (!MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(initializer2)) continue;
                    return true;
                }
                return false;
            }
            if (expression2 instanceof PsiReferenceExpression) {
                return expression2.getType() instanceof PsiArrayType;
            }
            if (expression2 instanceof PsiArrayAccessExpression) {
                return true;
            }
            if (expression2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
                return MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(typeCastExpression.getOperand());
            }
            if (expression2 instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
                return MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(conditionalExpression.getThenExpression()) || MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(conditionalExpression.getElseExpression());
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiClass aClass2;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return false;
                }
                String name = method.getName();
                return !("copyOf".equals(name) || "copyOfRange".equals(name) ? (aClass2 = method.getContainingClass()) != null && "java.util.Arrays".equals(aClass2.getQualifiedName()) : "toArray".equals(name) && InheritanceUtil.isInheritor(method.getContainingClass(), "java.util.Collection"));
            }
            return true;
        }

        static boolean isZeroSizeArrayExpression(PsiExpression initializer2) {
            if (initializer2 == null) {
                return true;
            }
            if (initializer2 instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)initializer2;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return arrayInitializer == null || MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(arrayInitializer);
            }
            if (initializer2 instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer2;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                return initializers.length == 0;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class ArrayReadWriteVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable myVariable;
            private boolean myWritten;
            private boolean myRead;
            private boolean myIsReferenced;

            ArrayReadWriteVisitor(@NotNull PsiVariable variable2, boolean written) {
                if (variable2 == null) {
                    ArrayReadWriteVisitor.$$$reportNull$$$0(0);
                }
                this.myRead = false;
                this.myIsReferenced = false;
                this.myVariable = variable2;
                this.myWritten = written;
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (this.myWritten && this.myRead) {
                    return;
                }
                super.visitReferenceExpression(expression2);
                PsiElement target = expression2.resolve();
                if (target != this.myVariable) {
                    return;
                }
                if (PsiUtil.isAccessedForWriting(expression2)) {
                    PsiElement parent2 = PsiTreeUtil.skipParentsOfType(expression2, PsiParenthesizedExpression.class);
                    if (parent2 instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
                        PsiExpression rhs = assignmentExpression.getRExpression();
                        if (MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(rhs)) {
                            this.myWritten = true;
                            this.myRead = true;
                        } else if (!MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(rhs)) {
                            this.myWritten = true;
                        }
                    }
                    return;
                }
                this.myIsReferenced = true;
                PsiElement parent3 = ArrayReadWriteVisitor.getParent(expression2);
                if (parent3 instanceof PsiArrayAccessExpression) {
                    int dimensions;
                    PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent3;
                    parent3 = ArrayReadWriteVisitor.getParent(parent3);
                    while (parent3 instanceof PsiArrayAccessExpression) {
                        arrayAccessExpression = (PsiArrayAccessExpression)parent3;
                        parent3 = ArrayReadWriteVisitor.getParent(parent3);
                    }
                    PsiType type2 = arrayAccessExpression.getType();
                    if (type2 != null && (dimensions = type2.getArrayDimensions()) > 0 && dimensions != this.myVariable.getType().getArrayDimensions()) {
                        this.myWritten = true;
                    }
                    if (PsiUtil.isAccessedForWriting(arrayAccessExpression)) {
                        this.myWritten = true;
                    }
                    if (PsiUtil.isAccessedForReading(arrayAccessExpression)) {
                        this.myRead = true;
                    }
                } else if (parent3 instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent3;
                    String name = referenceExpression.getReferenceName();
                    if ("length".equals(name) || "clone".equals(name) && referenceExpression.getParent() instanceof PsiMethodCallExpression) {
                        this.myRead = true;
                    }
                } else if (parent3 instanceof PsiForeachStatement) {
                    PsiForeachStatement foreachStatement = (PsiForeachStatement)parent3;
                    PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                    if (PsiTreeUtil.isAncestor(iteratedValue, expression2, false)) {
                        this.myRead = true;
                    }
                } else if (parent3 instanceof PsiExpressionList) {
                    PsiClass aClass2;
                    PsiMethodCallExpression methodCallExpression;
                    PsiMethod method;
                    PsiExpressionList expressionList = (PsiExpressionList)parent3;
                    if ((parent3 = parent3.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)parent3).resolveMethod()) != null && (aClass2 = method.getContainingClass()) != null) {
                        String methodName = method.getName();
                        String qualifiedName2 = aClass2.getQualifiedName();
                        if ("java.lang.System".equals(qualifiedName2)) {
                            PsiExpression[] expressions;
                            if ("arraycopy".equals(methodName) && (expressions = expressionList.getExpressions()).length == 5) {
                                if (PsiTreeUtil.isAncestor(expressions[0], expression2, false)) {
                                    this.myRead = true;
                                    return;
                                }
                                if (PsiTreeUtil.isAncestor(expressions[2], expression2, false)) {
                                    this.myWritten = true;
                                    return;
                                }
                            }
                        } else if ("java.util.Arrays".equals(qualifiedName2)) {
                            if ("fill".equals(methodName) || "parallelPrefix".equals(methodName) || "parallelSetAll".equals(methodName) || "parallelSort".equals(methodName) || "setAll".equals(methodName) || "sort".equals(methodName)) {
                                this.myWritten = true;
                            } else {
                                this.myRead = true;
                            }
                            return;
                        }
                    }
                    this.myRead = true;
                    this.myWritten = true;
                } else {
                    this.myWritten = true;
                    this.myRead = true;
                }
            }

            private static PsiElement getParent(PsiElement element) {
                PsiElement parent2 = element.getParent();
                while (parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiTypeCastExpression || parent2 instanceof PsiConditionalExpression) {
                    parent2 = parent2.getParent();
                }
                return parent2;
            }

            public boolean isRead() {
                return this.myRead;
            }

            public boolean isWritten() {
                return this.myWritten;
            }

            public boolean isReferenced() {
                return this.myIsReferenced;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$ArrayReadWriteVisitor", "<init>"));
            }
        }
    }
}

