/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullArgumentToVariableArgMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ConfusingArgumentToVarargsMethod" == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(0);
        }
        return "ConfusingArgumentToVarargsMethod";
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "NullArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("null.argument.to.var.arg.method.display.name", new Object[0]);
        if (string == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("null.argument.to.var.arg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        PsiExpression argument = (PsiExpression)infos2[0];
        PsiType type1 = (PsiType)infos2[1];
        PsiType type2 = (PsiType)infos2[2];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new DelegatingFix(new AddTypeCastFix(type1, argument)), new DelegatingFix(new AddTypeCastFix(type2, argument))};
        if (inspectionGadgetsFixArray == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NullArgumentToVariableArgVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NullArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private NullArgumentToVariableArgVisitor() {
        }

        @Override
        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            super.visitEnumConstant(enumConstant);
            this.visitCall(enumConstant);
        }

        @Override
        public void visitCallExpression(PsiCallExpression call2) {
            super.visitCallExpression(call2);
            this.visitCall(call2);
        }

        private void visitCall(PsiCall call2) {
            boolean checkArray;
            PsiExpressionList argumentList2 = call2.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments2[arguments2.length - 1];
            PsiType type2 = lastArgument.getType();
            if (PsiType.NULL.equals(type2)) {
                checkArray = false;
            } else if (type2 instanceof PsiArrayType) {
                checkArray = true;
            } else {
                return;
            }
            PsiMethod method = call2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != arguments2.length) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter lastParameter = parameters2[parameters2.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiType type1 = lastParameter.getType();
            if (!(type1 instanceof PsiEllipsisType)) {
                return;
            }
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type1;
            PsiType arrayType = ellipsisType.toArrayType();
            PsiType componentType = ellipsisType.getComponentType();
            if (checkArray) {
                if (!componentType.equals(TypeUtils.getObjectType(call2))) {
                    return;
                }
                if (type2.isAssignableFrom(arrayType) || !arrayType.isAssignableFrom(type2)) {
                    return;
                }
            }
            this.registerError((PsiElement)lastArgument, lastArgument, componentType, arrayType);
        }
    }
}

