/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousSystemArraycopyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.system.arraycopy.display.name", new Object[0]);
        if (string == null) {
            SuspiciousSystemArraycopyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = (String)infos2[0];
        if (string == null) {
            SuspiciousSystemArraycopyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousSystemArraycopyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SuspiciousSystemArraycopyVisitor
    extends BaseInspectionVisitor {
        private SuspiciousSystemArraycopyVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiExpression dest;
            PsiType destType;
            PsiExpression src;
            PsiType srcType;
            PsiExpression length;
            PsiExpression destPos;
            if (expression2 == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiClassType objectType = TypeUtils.getObjectType(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, "java.lang.System", (PsiType)PsiType.VOID, "arraycopy", objectType, PsiType.INT, objectType, PsiType.INT, PsiType.INT)) {
                return;
            }
            PsiExpression[] arguments2 = expression2.getArgumentList().getExpressions();
            if (arguments2.length != 5) {
                return;
            }
            PsiExpression srcPos = arguments2[1];
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(srcPos)) {
                this.registerError((PsiElement)srcPos, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor1", new Object[0]));
            }
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(destPos = arguments2[3])) {
                this.registerError((PsiElement)destPos, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor2", new Object[0]));
            }
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(length = arguments2[4])) {
                this.registerError((PsiElement)length, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor3", new Object[0]));
            }
            if ((srcType = (src = arguments2[0]).getType()) == null) {
                return;
            }
            boolean notArrayReported = false;
            if (!(srcType instanceof PsiArrayType)) {
                this.registerError((PsiElement)src, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor4", new Object[0]));
                notArrayReported = true;
            }
            if ((destType = (dest = arguments2[2]).getType()) == null) {
                return;
            }
            if (!(destType instanceof PsiArrayType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor5", new Object[0]));
                notArrayReported = true;
            }
            if (notArrayReported) {
                return;
            }
            PsiArrayType srcArrayType = (PsiArrayType)srcType;
            PsiArrayType destArrayType = (PsiArrayType)destType;
            PsiType srcComponentType = srcArrayType.getComponentType();
            PsiType destComponentType = destArrayType.getComponentType();
            if (!(srcComponentType instanceof PsiPrimitiveType)) {
                if (!destComponentType.isAssignableFrom(srcComponentType)) {
                    this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
                }
            } else if (!destComponentType.equals(srcComponentType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
            }
        }

        private static boolean isNegativeArgument(@NotNull PsiExpression argument) {
            Object constant;
            if (argument == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(1);
            }
            if (!((constant = ExpressionUtils.computeConstantExpression(argument)) instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)constant;
            return integer < 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection$SuspiciousSystemArraycopyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNegativeArgument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

