/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;

public class CallMapper<T> {
    private Map<String, List<CallHandler<T>>> myMap = new HashMap<String, List<CallHandler<T>>>();

    public CallMapper() {
    }

    public CallMapper(CallHandler<T> ... handlers2) {
        for (CallHandler<T> handler2 : handlers2) {
            this.register(handler2);
        }
    }

    public CallMapper<T> register(CallHandler<T> handler2) {
        handler2.matcher().names().forEach(name -> this.myMap.computeIfAbsent((String)name, k -> new ArrayList()).add(handler2));
        return this;
    }

    public CallMapper<T> register(CallMatcher matcher, Function<PsiMethodCallExpression, T> handler2) {
        return this.register(CallHandler.of(matcher, handler2));
    }

    public CallMapper<T> register(CallMatcher matcher, T value) {
        return this.register(CallHandler.of(matcher, call2 -> value));
    }

    public CallMapper<T> registerAll(List<CallHandler<T>> handlers2) {
        handlers2.forEach(this::register);
        return this;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethodCallExpression call2) {
        if (call2 == null) {
            return null;
        }
        List<CallHandler<T>> functions2 = this.myMap.get(call2.getMethodExpression().getReferenceName());
        if (functions2 == null) {
            return null;
        }
        for (Function function2 : functions2) {
            Object t = function2.apply(call2);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    public T mapFirst(PsiMethodReferenceExpression methodRef) {
        if (methodRef == null) {
            return null;
        }
        List<CallHandler<T>> functions2 = this.myMap.get(methodRef.getReferenceName());
        if (functions2 == null) {
            return null;
        }
        for (CallHandler<T> function2 : functions2) {
            T t = function2.applyMethodReference(methodRef);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Stream<T> mapAll(PsiMethodCallExpression call2) {
        if (call2 == null) {
            return null;
        }
        List<CallHandler<T>> functions2 = this.myMap.get(call2.getMethodExpression().getReferenceName());
        if (functions2 == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(functions2).map(fn -> fn.apply(call2)).nonNull();
    }
}

