/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import org.jetbrains.annotations.NotNull;

public class AnonymousClassMethodCountInspectionBase
extends ClassMetricInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 1;

    @Override
    @NotNull
    public String getID() {
        if ("AnonymousInnerClassWithTooManyMethods" == null) {
            AnonymousClassMethodCountInspectionBase.$$$reportNull$$$0(0);
        }
        return "AnonymousInnerClassWithTooManyMethods";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.display.name", new Object[0]);
        if (string == null) {
            AnonymousClassMethodCountInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer count2 = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.problem.descriptor", count2);
        if (string == null) {
            AnonymousClassMethodCountInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousClassMethodCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AnonymousClassMethodCountVisitor
    extends BaseInspectionVisitor {
        private AnonymousClassMethodCountVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                AnonymousClassMethodCountVisitor.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass2) {
            if (aClass2 == null) {
                AnonymousClassMethodCountVisitor.$$$reportNull$$$0(1);
            }
            if (aClass2 instanceof PsiEnumConstantInitializer) {
                return;
            }
            int totalMethodCount = this.calculateTotalMethodCount(aClass2);
            if (totalMethodCount <= AnonymousClassMethodCountInspectionBase.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass2, totalMethodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass2) {
            return aClass2.getMethods().length - aClass2.getConstructors().length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspectionBase$AnonymousClassMethodCountVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnonymousClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

