/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CouplingVisitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ClassCouplingInspection
extends ClassMetricInspection {
    private static final int DEFAULT_COUPLING_LIMIT = 15;
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @Override
    @NotNull
    public String getID() {
        if ("OverlyCoupledClass" == null) {
            ClassCouplingInspection.$$$reportNull$$$0(0);
        }
        return "OverlyCoupledClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.coupled.class.display.name", new Object[0]);
        if (string == null) {
            ClassCouplingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer totalDependencies = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("overly.coupled.class.problem.descriptor", totalDependencies);
        if (string == null) {
            ClassCouplingInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 15;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("overly.coupled.class.class.coupling.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        String configurationLabel = this.getConfigurationLabel();
        JLabel label2 = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets.right = 10;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label2, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        constraints.anchor = 18;
        constraints.fill = 0;
        panel.add((Component)valueField, constraints);
        CheckBox arrayCheckBox = new CheckBox(InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), this, "m_includeJavaClasses");
        CheckBox objectCheckBox = new CheckBox(InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), this, "m_includeLibraryClasses");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)arrayCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        panel.add((Component)objectCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassCouplingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ClassCouplingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassCouplingVisitor
    extends BaseInspectionVisitor {
        private ClassCouplingVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            int totalDependencies;
            if (aClass2 == null) {
                ClassCouplingVisitor.$$$reportNull$$$0(0);
            }
            if ((totalDependencies = this.calculateTotalDependencies(aClass2)) <= ClassCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass2, totalDependencies);
        }

        private int calculateTotalDependencies(PsiClass aClass2) {
            CouplingVisitor visitor2 = new CouplingVisitor(aClass2, ClassCouplingInspection.this.m_includeJavaClasses, ClassCouplingInspection.this.m_includeLibraryClasses);
            aClass2.accept(visitor2);
            return visitor2.getNumDependencies();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ClassCouplingInspection$ClassCouplingVisitor", "visitClass"));
        }
    }
}

