/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ClassNestingDepthInspection
extends ClassMetricInspection {
    private static final int CLASS_NESTING_LIMIT = 1;

    @Override
    @NotNull
    public String getID() {
        if ("InnerClassTooDeeplyNested" == null) {
            ClassNestingDepthInspection.$$$reportNull$$$0(0);
        }
        return "InnerClassTooDeeplyNested";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.too.deeply.nested.display.name", new Object[0]);
        if (string == null) {
            ClassNestingDepthInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("inner.class.too.deeply.nested.nesting.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer nestingLevel = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("inner.class.too.deeply.nested.problem.descriptor", nestingLevel);
        if (string == null) {
            ClassNestingDepthInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNestingLevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ClassNestingDepthInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassNestingLevel
    extends BaseInspectionVisitor {
        private ClassNestingLevel() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                ClassNestingLevel.$$$reportNull$$$0(0);
            }
            if (aClass2 instanceof PsiTypeParameter) {
                return;
            }
            int nestingLevel = this.getNestingLevel(aClass2);
            if (nestingLevel <= ClassNestingDepthInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass2, nestingLevel);
        }

        private int getNestingLevel(PsiClass aClass2) {
            int nestingLevel = 0;
            for (PsiElement ancestor = aClass2.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                if (!(ancestor instanceof PsiClass)) continue;
                ++nestingLevel;
            }
            return nestingLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ClassNestingDepthInspection$ClassNestingLevel", "visitClass"));
        }
    }
}

