/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MethodCountInspection
extends BaseInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 20;
    public int m_limit = 20;
    public boolean ignoreGettersAndSetters = false;
    public boolean ignoreOverridingMethods = false;

    @Override
    @NotNull
    public String getID() {
        if ("ClassWithTooManyMethods" == null) {
            MethodCountInspection.$$$reportNull$$$0(0);
        }
        return "ClassWithTooManyMethods";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.many.methods.display.name", new Object[0]);
        if (string == null) {
            MethodCountInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label2 = new JLabel(InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]));
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.anchor = 17;
        panel.add((Component)label2, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        panel.add((Component)valueField, constraints);
        CheckBox gettersSettersCheckBox = new CheckBox(InspectionGadgetsBundle.message("method.count.ignore.getters.setters.option", new Object[0]), this, "ignoreGettersAndSetters");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        panel.add((Component)gettersSettersCheckBox, constraints);
        CheckBox overridingMethodCheckBox = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), this, "ignoreOverridingMethods");
        constraints.weighty = 1.0;
        constraints.gridy = 2;
        constraints.anchor = 18;
        panel.add((Component)overridingMethodCheckBox, constraints);
        return panel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer count2 = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("too.many.methods.problem.descriptor", count2);
        if (string == null) {
            MethodCountInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/MethodCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodCountVisitor
    extends BaseInspectionVisitor {
        private MethodCountVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            int methodCount;
            if (aClass2 == null) {
                MethodCountVisitor.$$$reportNull$$$0(0);
            }
            if ((methodCount = this.calculateTotalMethodCount(aClass2)) <= MethodCountInspection.this.m_limit) {
                return;
            }
            this.registerClassError(aClass2, methodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass2) {
            PsiMethod[] methods2 = aClass2.getMethods();
            int totalCount = 0;
            for (PsiMethod method : methods2) {
                if (method.isConstructor() || MethodCountInspection.this.ignoreGettersAndSetters && (PropertyUtil.isSimpleGetter(method) || PropertyUtil.isSimpleSetter(method)) || MethodCountInspection.this.ignoreOverridingMethods && MethodUtils.hasSuper(method)) continue;
                ++totalCount;
            }
            return totalCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/MethodCountInspection$MethodCountVisitor", "visitClass"));
        }
    }
}

