/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneDeclaresCloneNotSupportedInspection
extends BaseInspection {
    public boolean onlyWarnOnProtectedClone = true;

    @Override
    @NotNull
    public String getID() {
        if ("CloneDoesntDeclareCloneNotSupportedException" == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(0);
        }
        return "CloneDoesntDeclareCloneNotSupportedException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.display.name", new Object[0]);
        if (string == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.problem.descriptor", new Object[0]);
        if (string == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("only.warn.on.protected.clone.methods", new Object[0]), this, "onlyWarnOnProtectedClone");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(3);
        }
        this.writeBooleanOption(node, "onlyWarnOnProtectedClone", true);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new CloneDeclaresCloneNotSupportedInspectionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneDeclaresCloneNotSupportedExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloneDeclaresCloneNotSupportedExceptionVisitor
    extends BaseInspectionVisitor {
        private CloneDeclaresCloneNotSupportedExceptionVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                CloneDeclaresCloneNotSupportedExceptionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (method.hasModifierProperty("final")) {
                return;
            }
            if (CloneDeclaresCloneNotSupportedInspection.this.onlyWarnOnProtectedClone && method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasInThrows(method, "java.lang.CloneNotSupportedException")) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod != null && !MethodUtils.hasInThrows(superMethod, "java.lang.CloneNotSupportedException")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedExceptionVisitor", "visitMethod"));
        }
    }

    private static class CloneDeclaresCloneNotSupportedInspectionFix
    extends InspectionGadgetsFix {
        private CloneDeclaresCloneNotSupportedInspectionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.declare.quickfix", new Object[0]);
            if (string == null) {
                CloneDeclaresCloneNotSupportedInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor2.getPsiElement();
            PsiMethod method = (PsiMethod)methodNameIdentifier.getParent();
            PsiUtil.addException(method, "java.lang.CloneNotSupportedException");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedInspectionFix", "getFamilyName"));
        }
    }
}

