/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class ConditionalExpressionWithIdenticalBranchesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.display.name", new Object[0]);
        if (string == null) {
            ConditionalExpressionWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.problem.descriptor", new Object[0]);
        if (string == null) {
            ConditionalExpressionWithIdenticalBranchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new CollapseConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression = expression2.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression2.getElseExpression();
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, elseExpression)) {
                this.registerError((PsiElement)expression2, new Object[0]);
            }
        }
    }

    private static class CollapseConditionalFix
    extends InspectionGadgetsFix {
        private CollapseConditionalFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.collapse.quickfix", new Object[0]);
            if (string == null) {
                CollapseConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)descriptor2.getPsiElement();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, elseExpression)) {
                PsiReplacementUtil.replaceExpression(conditionalExpression, thenExpression.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection$CollapseConditionalFix", "getFamilyName"));
        }
    }
}

