/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingElseInspection
extends BaseInspection {
    public boolean reportWhenNoStatementFollow = true;

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ConfusingElseBranch" == null) {
            ConfusingElseInspection.$$$reportNull$$$0(0);
        }
        return "ConfusingElseBranch";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.else.display.name", new Object[0]);
        if (string == null) {
            ConfusingElseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("redundant.else.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingElseInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("confusing.else.option", new Object[0]), this, "reportWhenNoStatementFollow");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingElseVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new RemoveRedundantElseFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConfusingElseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ConfusingElseVisitor
    extends BaseInspectionVisitor {
        private ConfusingElseVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            PsiKeyword elseToken;
            if (statement2 == null) {
                ConfusingElseVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement2);
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement2.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            if (!ConfusingElseInspection.this.reportWhenNoStatementFollow) {
                PsiStatement nextStatement = this.getNextStatement(statement2);
                if (nextStatement == null) {
                    return;
                }
                if (!ControlFlowUtils.statementMayCompleteNormally(elseBranch)) {
                    return;
                }
            }
            if ((elseToken = statement2.getElseElement()) == null) {
                return;
            }
            if (this.parentCompletesNormally(statement2)) {
                return;
            }
            this.registerError((PsiElement)elseToken, new Object[0]);
        }

        private boolean parentCompletesNormally(PsiElement element) {
            PsiElement parent2 = element.getParent();
            while (parent2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent2;
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != element) {
                    return true;
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return true;
                }
                element = parent2;
                parent2 = element.getParent();
            }
            return !(parent2 instanceof PsiCodeBlock);
        }

        @Nullable
        private PsiStatement getNextStatement(PsiIfStatement statement2) {
            PsiIfStatement parentIfStatement;
            PsiStatement elseBranch;
            PsiElement parent2;
            while ((parent2 = statement2.getParent()) instanceof PsiIfStatement && (elseBranch = (parentIfStatement = (PsiIfStatement)parent2).getElseBranch()) == statement2) {
                statement2 = parentIfStatement;
            }
            return PsiTreeUtil.getNextSiblingOfType(statement2, PsiStatement.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/ConfusingElseInspection$ConfusingElseVisitor", "visitIfStatement"));
        }
    }

    private static class RemoveRedundantElseFix
    extends InspectionGadgetsFix {
        private RemoveRedundantElseFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.else.unwrap.quickfix", new Object[0]);
            if (string == null) {
                RemoveRedundantElseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor2.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifKeyword.getParent();
            if (ifStatement == null) {
                return;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiElement anchor2 = ifStatement;
            PsiElement parent2 = anchor2.getParent();
            while (parent2 instanceof PsiIfStatement) {
                anchor2 = parent2;
                parent2 = anchor2.getParent();
            }
            if (elseBranch instanceof PsiBlockStatement) {
                PsiBlockStatement elseBlock = (PsiBlockStatement)elseBranch;
                PsiCodeBlock block = elseBlock.getCodeBlock();
                PsiElement[] children2 = block.getChildren();
                if (children2.length > 2) {
                    parent2.addRangeAfter(children2[1], children2[children2.length - 2], anchor2);
                }
            } else {
                parent2.addAfter(elseBranch, anchor2);
            }
            elseBranch.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConfusingElseInspection$RemoveRedundantElseFix", "getFamilyName"));
        }
    }
}

