/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreSideEffectConditions = true;
    private static final int LIMIT_DEPTH = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("duplicate.condition.display.name", new Object[0]);
        if (string == null) {
            DuplicateConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            DuplicateConditionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), this, "ignoreSideEffectConditions");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/DuplicateConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private Set<PsiIfStatement> myAnalyzedStatements = new HashSet<PsiIfStatement>();

        private DuplicateConditionVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            if (statement2 == null) {
                DuplicateConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement2);
            if (ControlFlowUtils.isElseIf(statement2)) {
                return;
            }
            LinkedHashSet<PsiExpression> conditions2 = new LinkedHashSet<PsiExpression>();
            this.collectConditionsForIfStatement(statement2, conditions2, 0);
            int numConditions = conditions2.size();
            if (numConditions < 2) {
                return;
            }
            ArrayList<PsiExpression> conditionList = new ArrayList<PsiExpression>(conditions2);
            if (DuplicateConditionInspection.this.ignoreSideEffectConditions) {
                conditionList.replaceAll(cond -> SideEffectChecker.mayHaveSideEffects(cond) ? null : cond);
                ((StreamEx)StreamEx.of(conditionList).groupRuns((a2, b2) -> a2 != null && b2 != null).filter(list2 -> list2.size() >= 2)).forEach(this::findDuplicates);
            } else {
                this.findDuplicates(conditionList);
            }
        }

        private void findDuplicates(List<PsiExpression> conditions2) {
            BitSet matched = new BitSet();
            for (int i2 = 0; i2 < conditions2.size(); ++i2) {
                if (matched.get(i2)) continue;
                PsiExpression condition = conditions2.get(i2);
                for (int j = i2 + 1; j < conditions2.size(); ++j) {
                    if (matched.get(j)) continue;
                    PsiExpression testCondition = conditions2.get(j);
                    boolean areEquivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(condition, testCondition);
                    if (!areEquivalent) continue;
                    this.registerError((PsiElement)testCondition, new Object[0]);
                    if (!matched.get(i2)) {
                        this.registerError((PsiElement)condition, new Object[0]);
                    }
                    matched.set(i2);
                    matched.set(j);
                }
            }
        }

        private void collectConditionsForIfStatement(PsiIfStatement statement2, Set<PsiExpression> conditions2, int depth) {
            if (depth > 20 || !this.myAnalyzedStatements.add(statement2)) {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            this.collectConditionsForExpression(condition, conditions2);
            PsiStatement branch = ControlFlowUtils.stripBraces(statement2.getElseBranch());
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatement((PsiIfStatement)branch, conditions2, depth + 1);
            }
            if (branch == null) {
                PsiStatement thenBranch = statement2.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return;
                }
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward(statement2);
                if (next instanceof PsiIfStatement) {
                    this.collectConditionsForIfStatement((PsiIfStatement)next, conditions2, depth + 1);
                }
            }
        }

        private void collectConditionsForExpression(PsiExpression condition, Set<PsiExpression> conditions2) {
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if (condition == null) {
                return;
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                PsiExpression contents = parenthesizedExpression.getExpression();
                this.collectConditionsForExpression(contents, conditions2);
                return;
            }
            if (condition instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)condition).getOperationTokenType())) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    this.collectConditionsForExpression(operand, conditions2);
                }
                return;
            }
            conditions2.add(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/DuplicateConditionInspection$DuplicateConditionVisitor", "visitIfStatement"));
        }
    }
}

