/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementDensityInspection
extends BaseInspection {
    private static final int DEFAULT_DENSITY_LIMIT = 20;
    public int m_limit = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.density.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementDensityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.density.min.option", new Object[0]), this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        Integer intDensity = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("switch.statement.density.problem.descriptor", intDensity);
        if (string == null) {
            SwitchStatementDensityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementDensityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementDensityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StatementCountVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int statementCount;

        private StatementCountVisitor() {
        }

        @Override
        public void visitStatement(@NotNull PsiStatement statement2) {
            if (statement2 == null) {
                StatementCountVisitor.$$$reportNull$$$0(0);
            }
            super.visitStatement(statement2);
            if (statement2 instanceof PsiSwitchLabelStatement || statement2 instanceof PsiBreakStatement) {
                return;
            }
            ++this.statementCount;
        }

        int getStatementCount() {
            return this.statementCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$StatementCountVisitor", "visitStatement"));
        }
    }

    private class SwitchStatementDensityVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementDensityVisitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            PsiCodeBlock body2;
            if (statement2 == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(0);
            }
            if ((body2 = statement2.getBody()) == null) {
                return;
            }
            int branchCount = SwitchUtils.calculateBranchCount(statement2);
            if (branchCount == 0) {
                return;
            }
            double density = this.calculateDensity(body2, branchCount < 0 ? -branchCount + 1 : branchCount);
            int intDensity = (int)(density * 100.0);
            if (intDensity > SwitchStatementDensityInspection.this.m_limit) {
                return;
            }
            this.registerStatementError(statement2, intDensity);
        }

        private double calculateDensity(@NotNull PsiCodeBlock body2, int branchCount) {
            if (body2 == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(1);
            }
            StatementCountVisitor visitor2 = new StatementCountVisitor();
            body2.accept(visitor2);
            return (double)branchCount / (double)visitor2.getStatementCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$SwitchStatementDensityVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateDensity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

