/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("RedundantIfStatement" == null) {
            TrivialIfInspection.$$$reportNull$$$0(0);
        }
        return "RedundantIfStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.if.display.name", new Object[0]);
        if (string == null) {
            TrivialIfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            TrivialIfInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new TrivialIfFix();
    }

    public static void simplify(PsiIfStatement statement2) {
        if (TrivialIfInspection.isSimplifiableAssignment(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssignment(statement2);
        } else if (TrivialIfInspection.isSimplifiableReturn(statement2)) {
            TrivialIfInspection.replaceSimplifiableReturn(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturn(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturn(statement2);
        } else if (TrivialIfInspection.isSimplifiableAssignmentNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssignmentNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableReturnNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableReturnNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturnNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignment(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignment(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignmentNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableAssert(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssert(statement2);
        }
    }

    private static void replaceSimplifiableAssert(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        if (statement2.getElseBranch() != null) {
            return;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement2.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        if (assertCondition == null) {
            return;
        }
        PsiExpression replacementCondition = JavaPsiFacade.getElementFactory(statement2.getProject()).createExpressionFromText(BoolUtils.isFalse(assertCondition) ? conditionText : conditionText + "||" + assertCondition.getText(), statement2);
        assertCondition.replace(replacementCondition);
        statement2.replace(assertStatement);
    }

    private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiReturnStatement nextStatement = ControlFlowUtils.getNextReturnStatement(statement2);
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement2, newStatement);
        assert (nextStatement != null);
        if (!ControlFlowUtils.isReachable(nextStatement)) {
            nextStatement.delete();
        }
    }

    private static void replaceSimplifiableReturn(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        Collection<PsiComment> comments = PsiTreeUtil.findChildrenOfType(statement2, PsiComment.class);
        PsiElement parent2 = statement2.getParent();
        for (PsiComment comment : comments) {
            parent2.addBefore(comment.copy(), statement2);
        }
        String conditionText = condition.getText();
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement2, newStatement);
    }

    private static void replaceSimplifiableAssignment(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(statement2, PsiComment.class), comment -> (PsiComment)comment.copy());
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiElement parent2 = statement2.getParent();
        for (PsiComment comment2 : comments) {
            parent2.addBefore(comment2, statement2);
        }
        PsiReplacementUtil.replaceStatement(statement2, lhsText + operand + conditionText + ';');
    }

    private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement2) {
        PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward(statement2);
        if (prevStatement == null) {
            return;
        }
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement(statement2, lhsText + operand + conditionText + ';');
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitAssignmentNegated(PsiIfStatement statement2) {
        PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward(statement2);
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement(statement2, lhsText + operand + conditionText + ';');
        assert (prevStatement != null);
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitReturnNegated(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiReturnStatement nextStatement = ControlFlowUtils.getNextReturnStatement(statement2);
        if (nextStatement == null) {
            return;
        }
        PsiElement nextSibling = statement2.getNextSibling();
        if (nextSibling != nextStatement && nextStatement.getParent() == statement2.getParent()) {
            statement2.getParent().deleteChildRange(nextSibling, nextStatement.getPrevSibling());
        }
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement2, newStatement);
        if (!ControlFlowUtils.isReachable(nextStatement)) {
            nextStatement.delete();
        }
    }

    private static void replaceSimplifiableReturnNegated(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement(statement2, newStatement);
    }

    private static void replaceSimplifiableAssignmentNegated(PsiIfStatement statement2) {
        PsiExpression condition = statement2.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement(statement2, lhsText + operand + conditionText + ';');
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public static boolean isTrivial(PsiIfStatement ifStatement) {
        if (PsiUtilCore.hasErrorElementChild(ifStatement)) {
            return false;
        }
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement) || TrivialIfInspection.isSimplifiableReturn(ifStatement) || TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement) || TrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement) || TrivialIfInspection.isSimplifiableReturnNegated(ifStatement) || TrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement) || TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement) || TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement) || TrivialIfInspection.isSimplifiableAssert(ifStatement);
    }

    private static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableImplicitReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiReturnStatement elseBranch = ControlFlowUtils.getNextReturnStatement(ifStatement);
        return TrivialIfInspection.isReturn(thenBranch, thenReturn) && TrivialIfInspection.isReturn(elseBranch, elseReturn);
    }

    private static boolean isSimplifiableReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isReturn(thenBranch, thenReturn) && TrivialIfInspection.isReturn(elseBranch, elseReturn);
    }

    private static boolean isSimplifiableAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableImplicitAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward(ifStatement);
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableAssignment(PsiStatement thenBranch, PsiStatement elseBranch, String thenAssignment, String elseAssignment) {
        if (!TrivialIfInspection.isAssignment(thenBranch, thenAssignment) || !TrivialIfInspection.isAssignment(elseBranch, elseAssignment)) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
        IElementType thenTokenType = thenExpression.getOperationTokenType();
        if (!thenTokenType.equals(elseExpression.getOperationTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs);
    }

    private static boolean isReturn(PsiStatement statement2, String value) {
        if (!(statement2 instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
        PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
        return returnValue != null && value.equals(returnValue.getText());
    }

    private static boolean isAssignment(PsiStatement statement2, String value) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if (!(expression2 instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
        PsiExpression rhs = ParenthesesUtils.stripParentheses(assignment.getRExpression());
        return rhs != null && value.equals(rhs.getText());
    }

    private static boolean isSimplifiableAssert(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return false;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        return assertStatement.getAssertCondition() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/TrivialIfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                TrivialIfVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(ifStatement);
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (TrivialIfInspection.isTrivial(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
        }
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement ifKeywordElement = descriptor2.getPsiElement();
            PsiIfStatement statement2 = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getFamilyName"));
        }
    }
}

