/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getID() {
        if ("RedundantConditionalExpression" == null) {
            UnnecessaryConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return "RedundantConditionalExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String replacement = (String)infos2[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", replacement);
        if (string == null) {
            UnnecessaryConditionalExpressionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        String replacement = (String)infos2[0];
        return new UnnecessaryConditionalFix(replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression = expression2.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression2.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            PsiExpression condition = ParenthesesUtils.stripParentheses(expression2.getCondition());
            if (condition == null) {
                return;
            }
            if (BoolUtils.isFalse(thenExpression) && BoolUtils.isTrue(elseExpression)) {
                this.registerError((PsiElement)expression2, BoolUtils.getNegatedExpressionText(condition));
            } else if (BoolUtils.isTrue(thenExpression) && BoolUtils.isFalse(elseExpression)) {
                this.registerError((PsiElement)expression2, condition.getText());
            } else if (this.isUnnecessary(condition, thenExpression, elseExpression, JavaTokenType.EQEQ)) {
                this.registerError((PsiElement)expression2, elseExpression.getText());
            } else if (this.isUnnecessary(condition, elseExpression, thenExpression, JavaTokenType.NE)) {
                this.registerError((PsiElement)expression2, thenExpression.getText());
            }
        }

        boolean isUnnecessary(PsiExpression condition, PsiExpression thenExpression, PsiExpression elseExpression, IElementType expectedToken) {
            if (!(condition instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType token = binaryExpression.getOperationTokenType();
            if (token != expectedToken) {
                return false;
            }
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return equivalence.expressionsAreEquivalent(thenExpression, lhs) && equivalence.expressionsAreEquivalent(elseExpression, rhs) || equivalence.expressionsAreEquivalent(thenExpression, rhs) && equivalence.expressionsAreEquivalent(elseExpression, lhs);
        }
    }

    private static class UnnecessaryConditionalFix
    extends InspectionGadgetsFix {
        private final String myReplacement;

        public UnnecessaryConditionalFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor2.getPsiElement();
            PsiReplacementUtil.replaceExpression(expression2, this.myReplacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection$UnnecessaryConditionalFix", "getFamilyName"));
        }
    }
}

