/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantValueVariableUseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.display.name", new Object[0]);
        if (string == null) {
            ConstantValueVariableUseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantValueVariableUseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiExpression expression2 = (PsiExpression)infos2[0];
        return new ReplaceReferenceWithExpressionFix(expression2.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read;
        private boolean stop;
        private PsiReferenceExpression reference;

        VariableReadVisitor(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                VariableReadVisitor.$$$reportNull$$$0(0);
            }
            this.read = false;
            this.stop = false;
            this.reference = null;
            this.variable = variable2;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableReadVisitor.$$$reportNull$$$0(1);
            }
            if (this.read || this.stop) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.read || this.stop) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (this.variable.equals(target)) {
                if (PsiUtil.isAccessedForWriting(expression2)) {
                    this.stop = true;
                    return;
                }
                if (PsiUtil.isAccessedForReading(expression2)) {
                    if (VariableReadVisitor.isInLoopCondition(expression2)) {
                        this.stop = true;
                    } else {
                        this.reference = expression2;
                        this.read = true;
                    }
                    return;
                }
            }
            super.visitReferenceExpression(expression2);
        }

        private static boolean isInLoopCondition(PsiExpression expression2) {
            PsiStatement statement2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class, true, PsiMember.class, PsiLambdaExpression.class);
            return statement2 instanceof PsiLoopStatement;
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            PsiStatement body2 = statement2.getThenBranch();
            this.checkCondition(condition, body2);
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            PsiStatement body2 = statement2.getBody();
            this.checkCondition(condition, body2);
        }

        @Override
        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            PsiStatement body2 = statement2.getBody();
            this.checkCondition(condition, body2);
        }

        private boolean checkCondition(@Nullable PsiExpression condition, @Nullable PsiStatement body2) {
            if (body2 == null) {
                return false;
            }
            if (!(condition instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND == tokenType) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!this.checkCondition(operand, body2)) continue;
                    return true;
                }
                return false;
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length != 2) {
                return false;
            }
            PsiExpression lhs = operands[0];
            PsiExpression rhs = operands[1];
            if (PsiUtil.isConstantExpression(lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, body2);
            }
            if (PsiUtil.isConstantExpression(rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, body2);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression2, @NotNull PsiExpression constantExpression, @NotNull PsiElement body2) {
            PsiType constantType;
            if (constantExpression == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(0);
            }
            if (body2 == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(1);
            }
            if (PsiType.DOUBLE.equals(constantType = constantExpression.getType())) {
                Object result2 = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result2) || Double.valueOf(-0.0).equals(result2)) {
                    return false;
                }
            }
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            if (target instanceof PsiField) {
                return false;
            }
            PsiVariable variable2 = (PsiVariable)target;
            VariableReadVisitor visitor2 = new VariableReadVisitor(variable2);
            body2.accept(visitor2);
            if (!visitor2.isRead()) {
                return false;
            }
            this.registerError((PsiElement)visitor2.getReference(), constantExpression);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constantExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor";
            objectArray[2] = "checkConstantValueVariableUse";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceReferenceWithExpressionFix
    extends InspectionGadgetsFix {
        private final String myText;

        ReplaceReferenceWithExpressionFix(String text2) {
            this.myText = text2;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("replace.reference.with.expression.quickfix", this.myText);
            if (string == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression2, this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

