/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReuseOfLocalVariableInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.display.name", new Object[0]);
        if (string == null) {
            ReuseOfLocalVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            ReuseOfLocalVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReuseOfLocalVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReuseOfLocalVariableVisitor
    extends BaseInspectionVisitor {
        private ReuseOfLocalVariableVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            int i2;
            if (assignment == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            PsiElement assignmentParent = assignment.getParent();
            if (!(assignmentParent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiLocalVariable)) {
                return;
            }
            PsiVariable variable2 = (PsiVariable)referent;
            if (variable2.getInitializer() == null) {
                return;
            }
            IElementType tokenType = assignment.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs != null && VariableAccessUtils.variableIsUsed(variable2, rhs)) {
                return;
            }
            PsiCodeBlock variableBlock = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class);
            if (variableBlock == null) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.loopExistsBetween(assignment, variableBlock)) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.tryExistsBetween(assignment, variableBlock)) {
                return;
            }
            PsiElement assignmentBlock = assignmentParent.getParent();
            if (assignmentBlock == null) {
                return;
            }
            if (variableBlock.equals(assignmentBlock)) {
                this.registerError((PsiElement)lhs, new Object[0]);
            }
            PsiStatement[] statements = variableBlock.getStatements();
            PsiElement containingStatement = ReuseOfLocalVariableVisitor.getChildWhichContainsElement(variableBlock, assignment);
            int statementPosition = -1;
            for (i2 = 0; i2 < statements.length; ++i2) {
                if (!statements[i2].equals(containingStatement)) continue;
                statementPosition = i2;
                break;
            }
            if (statementPosition == -1) {
                return;
            }
            for (i2 = statementPosition + 1; i2 < statements.length; ++i2) {
                if (!VariableAccessUtils.variableIsUsed(variable2, statements[i2])) continue;
                return;
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        private static boolean loopExistsBetween(PsiAssignmentExpression assignment, PsiCodeBlock block) {
            for (PsiElement elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof PsiWhileStatement) && !(elementToTest instanceof PsiForeachStatement) && !(elementToTest instanceof PsiForStatement) && !(elementToTest instanceof PsiDoWhileStatement)) continue;
                return true;
            }
            return false;
        }

        private static boolean tryExistsBetween(PsiAssignmentExpression assignment, PsiCodeBlock block) {
            for (PsiElement elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof PsiTryStatement)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static PsiElement getChildWhichContainsElement(@NotNull PsiCodeBlock ancestor, @NotNull PsiElement descendant) {
            if (ancestor == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if (descendant == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(2);
            }
            PsiElement element = descendant;
            while (!element.equals(ancestor)) {
                descendant = element;
                if ((element = descendant.getParent()) != null) continue;
                return null;
            }
            return descendant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descendant";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspectionBase$ReuseOfLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChildWhichContainsElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

