/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspectionBase
extends BaseInspection {
    public boolean m_allowConstructorAsInitializer = false;
    public boolean m_onlyLookAtBlocks = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.scope.display.name", new Object[0]);
        if (string == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("TooBroadScope" == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(1);
        }
        return "TooBroadScope";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel(this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.only.blocks.option", new Object[0]), "m_onlyLookAtBlocks");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.allow.option", new Object[0]), "m_allowConstructorAsInitializer");
        return checkboxOptionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("too.broad.scope.problem.descriptor", new Object[0]);
        if (string == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean isMoveable(PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return true;
        }
        if (PsiUtil.isConstantExpression(expression2) || ExpressionUtils.isNullLiteral(expression2)) {
            return true;
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer2 : arrayInitializerExpression.getInitializers()) {
                if (this.isMoveable(initializer2)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiExpression[] expressions;
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length > 0) {
                for (PsiExpression arrayDimension : arrayDimensions) {
                    if (this.isMoveable(arrayDimension)) continue;
                    return false;
                }
                return true;
            }
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer != null) {
                PsiExpression[] initializers;
                for (PsiExpression initializerExpression : initializers = arrayInitializer.getInitializers()) {
                    if (this.isMoveable(initializerExpression)) continue;
                    return false;
                }
                return true;
            }
            PsiType type2 = newExpression.getType();
            if (type2 == null) {
                return false;
            }
            if (!this.m_allowConstructorAsInitializer && !TooBroadScopeInspectionBase.isAllowedType(type2)) {
                return false;
            }
            PsiExpressionList argumentList2 = newExpression.getArgumentList();
            if (argumentList2 == null) {
                return false;
            }
            for (PsiExpression argumentExpression : expressions = argumentList2.getExpressions()) {
                if (this.isMoveable(argumentExpression)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (!this.isMoveable(qualifier)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiClass) {
                return true;
            }
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable2 = (PsiVariable)target;
            if (!ClassUtils.isImmutable(variable2.getType()) && !CollectionUtils.isEmptyArray(variable2)) {
                return false;
            }
            if (variable2.hasModifierProperty("final")) {
                return true;
            }
            PsiElement context = PsiUtil.getVariableCodeBlock(variable2, referenceExpression);
            return context != null && !(variable2 instanceof PsiField) && HighlightControlFlowUtil.isEffectivelyFinal(variable2, context, referenceExpression);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (this.isMoveable(operand)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            if (!TooBroadScopeInspectionBase.isAllowedType(expression2.getType())) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (!TooBroadScopeInspectionBase.isAllowedMethod(method)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && !this.isMoveable(qualifierExpression)) {
                return false;
            }
            PsiExpressionList argumentList3 = methodCallExpression.getArgumentList();
            for (PsiExpression argument : argumentList3.getExpressions()) {
                if (this.isMoveable(argument)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAllowedMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return false;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        if (qualifiedName2 == null || !qualifiedName2.startsWith("java.")) {
            return false;
        }
        String methodName = method.getName();
        return !"now".equals(methodName) && !"currentTimeMillis".equals(methodName) && !"nanoTime".equals(methodName) && !"waitFor".equals(methodName);
    }

    private static boolean isAllowedType(PsiType type2) {
        if (ClassUtils.isImmutable(type2)) {
            return true;
        }
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(type2);
        return TooBroadScopeInspectionBase.isAllowedClass(aClass2);
    }

    private static boolean isAllowedClass(@Nullable PsiClass aClass2) {
        if (InheritanceUtil.isInheritor(aClass2, "java.util.Collection") || InheritanceUtil.isInheritor(aClass2, "java.util.Map")) {
            return true;
        }
        return aClass2 != null && aClass2.isEnum();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadScopeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/TooBroadScopeInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TooBroadScopeVisitor
    extends BaseInspectionVisitor {
        TooBroadScopeVisitor() {
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                TooBroadScopeVisitor.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable2);
            if (!(variable2 instanceof PsiLocalVariable) || variable2 instanceof PsiResourceVariable) {
                return;
            }
            PsiExpression initializer2 = variable2.getInitializer();
            if (!TooBroadScopeInspectionBase.this.isMoveable(initializer2)) {
                return;
            }
            Object variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class, PsiForStatement.class);
            if (variableScope == null) {
                return;
            }
            Query<PsiReference> query = ReferencesSearch.search(variable2);
            Collection<PsiReference> referencesCollection = query.findAll();
            int size = referencesCollection.size();
            if (size == 0) {
                return;
            }
            PsiElement[] referenceElements = new PsiElement[referencesCollection.size()];
            int index2 = 0;
            for (PsiReference reference : referencesCollection) {
                PsiElement referenceElement;
                referenceElements[index2] = referenceElement = reference.getElement();
                ++index2;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(referenceElements);
            if (commonParent == null) {
                return;
            }
            if (initializer2 != null && (commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(commonParent, variableScope, true)) {
                return;
            }
            if (PsiTreeUtil.isAncestor(variableScope, commonParent, true)) {
                this.registerVariableError(variable2, variable2);
                return;
            }
            if (TooBroadScopeInspectionBase.this.m_onlyLookAtBlocks) {
                return;
            }
            if (commonParent instanceof PsiForStatement) {
                return;
            }
            PsiElement referenceElement = referenceElements[0];
            PsiElement blockChild = ScopeUtils.getChildWhichContainsElement(variableScope, referenceElement);
            if (blockChild == null) {
                return;
            }
            PsiElement insertionPoint = ScopeUtils.findTighterDeclarationLocation(blockChild, variable2);
            if (insertionPoint == null) {
                if (!(blockChild instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)blockChild;
                PsiExpression expression2 = expressionStatement.getExpression();
                if (!(expression2 instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQ) {
                    return;
                }
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!lhs.equals(referenceElement)) {
                    return;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed(variable2, rhs)) {
                    return;
                }
            }
            if (insertionPoint != null && FileTypeUtils.isInServerPageFile(insertionPoint)) {
                PsiElement variableParent;
                PsiElement elementBefore = insertionPoint.getPrevSibling();
                if ((elementBefore = PsiTreeUtil.skipWhitespacesBackward(elementBefore)) instanceof PsiDeclarationStatement && elementBefore.equals(variableParent = variable2.getParent())) {
                    return;
                }
            }
            this.registerVariableError(variable2, variable2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/dataflow/TooBroadScopeInspectionBase$TooBroadScopeVisitor", "visitVariable"));
        }
    }
}

