/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import org.jetbrains.annotations.NotNull;

public class PublicFieldInspectionBase
extends BaseInspection {
    public boolean ignoreEnums = false;
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet("org.junit.runners.Parameterized.Parameter");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.field.display.name", new Object[0]);
        if (string == null) {
            PublicFieldInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("public.field.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicFieldInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/encapsulation/PublicFieldInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PublicFieldVisitor
    extends BaseInspectionVisitor {
        private PublicFieldVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                PublicFieldVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated(field, PublicFieldInspectionBase.this.ignorableAnnotations)) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                PsiClassType classType;
                PsiClass aClass2;
                if (field.hasModifierProperty("static")) {
                    return;
                }
                PsiType type2 = field.getType();
                if (ClassUtils.isImmutable(type2)) {
                    return;
                }
                if (PublicFieldInspectionBase.this.ignoreEnums && type2 instanceof PsiClassType && (aClass2 = (classType = (PsiClassType)type2).resolve()) != null && aClass2.isEnum()) {
                    return;
                }
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/encapsulation/PublicFieldInspectionBase$PublicFieldVisitor", "visitField"));
        }
    }
}

