/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyCatchBlockInspectionBase
extends BaseInspection {
    public boolean m_includeComments = true;
    public boolean m_ignoreTestCases = true;
    public boolean m_ignoreIgnoreParameter = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.catch.block.display.name", new Object[0]);
        if (string == null) {
            EmptyCatchBlockInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("empty.catch.block.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyCatchBlockInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "m_includeComments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.ignore.ignore.option", new Object[0]), "m_ignoreIgnoreParameter");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new EmptyCatchBlockFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyCatchBlockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EmptyCatchBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyCatchBlockVisitor() {
        }

        @Override
        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            PsiCatchSection[] catchSections;
            if (statement2 == null) {
                EmptyCatchBlockVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement2);
            for (PsiCatchSection section2 : catchSections = statement2.getCatchSections()) {
                this.checkCatchSection(section2);
            }
        }

        private void checkCatchSection(PsiCatchSection section2) {
            PsiCodeBlock block = section2.getCatchBlock();
            if (block == null || !this.isEmpty(block)) {
                return;
            }
            PsiParameter parameter = section2.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            String parameterName = parameter.getName();
            if (EmptyCatchBlockInspectionBase.this.m_ignoreIgnoreParameter && PsiUtil.isIgnoredName(parameterName)) {
                return;
            }
            PsiElement catchToken = section2.getFirstChild();
            if (catchToken == null) {
                return;
            }
            this.registerError(catchToken, catchToken);
        }

        private boolean isEmpty(PsiElement element) {
            if (!EmptyCatchBlockInspectionBase.this.m_includeComments && element instanceof PsiComment) {
                return true;
            }
            if (element instanceof PsiEmptyStatement) {
                return !EmptyCatchBlockInspectionBase.this.m_includeComments || PsiTreeUtil.getChildOfType(element, PsiComment.class) == null;
            }
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)element;
                return this.isEmpty(block.getCodeBlock());
            }
            if (element instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)element;
                PsiElement lastBodyElement = codeBlock.getLastBodyElement();
                for (PsiElement bodyElement = codeBlock.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
                    if (!this.isEmpty(bodyElement)) {
                        return false;
                    }
                    if (bodyElement == lastBodyElement) break;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase$EmptyCatchBlockVisitor", "visitTryStatement"));
        }
    }

    private static class EmptyCatchBlockFix
    extends InspectionGadgetsFix {
        private EmptyCatchBlockFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", new Object[0]);
            if (string == null) {
                EmptyCatchBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)parent2;
            PsiParameter parameter = catchSection.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(project).getElementFactory();
            PsiIdentifier newIdentifier = factory2.createIdentifier("ignored");
            identifier.replace(newIdentifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase$EmptyCatchBlockFix", "getFamilyName"));
        }
    }
}

