/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class FinallyBlockCannotCompleteNormallyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("finally" == null) {
            FinallyBlockCannotCompleteNormallyInspection.$$$reportNull$$$0(0);
        }
        return "finally";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.display.name", new Object[0]);
        if (string == null) {
            FinallyBlockCannotCompleteNormallyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.problem.descriptor", new Object[0]);
        if (string == null) {
            FinallyBlockCannotCompleteNormallyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinallyBlockCannotCompleteNormallyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/FinallyBlockCannotCompleteNormallyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class FinallyBlockCannotCompleteNormallyVisitor
    extends BaseInspectionVisitor {
        private FinallyBlockCannotCompleteNormallyVisitor() {
        }

        @Override
        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            PsiElement[] children2;
            if (statement2 == null) {
                FinallyBlockCannotCompleteNormallyVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement2);
            PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
                return;
            }
            for (PsiElement child : children2 = statement2.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                this.registerError(child, new Object[0]);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/FinallyBlockCannotCompleteNormallyInspection$FinallyBlockCannotCompleteNormallyVisitor", "visitTryStatement"));
        }
    }
}

