/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchSectionFix
extends InspectionGadgetsFix {
    private final boolean removeTryCatch;

    public DeleteCatchSectionFix(boolean removeTryCatch) {
        this.removeTryCatch = removeTryCatch;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.removeTryCatch) {
            String string = InspectionGadgetsBundle.message("remove.try.catch.quickfix", new Object[0]);
            if (string == null) {
                DeleteCatchSectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("delete.catch.section.quickfix", new Object[0]);
        if (string == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Delete catch statement" == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(2);
        }
        return "Delete catch statement";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter = (PsiParameter)parent2;
        PsiElement grandParent = parameter.getParent();
        if (!(grandParent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)grandParent;
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        if (this.removeTryCatch) {
            boolean keepBlock;
            PsiCodeBlock codeBlock = tryStatement.getTryBlock();
            if (codeBlock == null) {
                return;
            }
            PsiElement containingElement = tryStatement.getParent();
            if (containingElement instanceof PsiCodeBlock) {
                PsiCodeBlock parentBlock = (PsiCodeBlock)containingElement;
                keepBlock = DeclarationSearchUtils.containsConflictingDeclarations(codeBlock, parentBlock);
            } else {
                keepBlock = true;
            }
            if (keepBlock) {
                tryStatement.replace(codeBlock);
            } else {
                PsiElement firstBodyElement = codeBlock.getFirstBodyElement();
                PsiElement lastBodyElement = codeBlock.getLastBodyElement();
                if (firstBodyElement != null && lastBodyElement != null) {
                    containingElement.addRangeBefore(firstBodyElement, lastBodyElement, tryStatement);
                }
                tryStatement.delete();
            }
        } else {
            catchSection.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/DeleteCatchSectionFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

