/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class NormalizeDeclarationFix
extends InspectionGadgetsFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("normalize.declaration.quickfix", new Object[0]);
        if (string == null) {
            NormalizeDeclarationFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiElement variableNameElement = descriptor2.getPsiElement();
        PsiVariable parent2 = (PsiVariable)variableNameElement.getParent();
        if (parent2 == null) {
            return;
        }
        if (parent2 instanceof PsiField) {
            parent2.normalizeDeclaration();
            return;
        }
        PsiElement grandParent = parent2.getParent();
        if (!(grandParent instanceof PsiDeclarationStatement)) {
            return;
        }
        PsiElement greatGrandParent = grandParent.getParent();
        if (greatGrandParent instanceof PsiForStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)grandParent;
            NormalizeDeclarationFix.splitMultipleDeclarationInForStatementInitialization(declarationStatement);
            return;
        }
        parent2.normalizeDeclaration();
    }

    private static void splitMultipleDeclarationInForStatementInitialization(PsiDeclarationStatement declarationStatement) {
        PsiElement declaredElement;
        int i2;
        PsiCodeBlock codeBlock;
        PsiBlockStatement blockStatement;
        PsiElement forStatement = declarationStatement.getParent();
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        Project project = forStatement.getProject();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
        PsiElement greatGreatGrandParent = forStatement.getParent();
        if (!(greatGreatGrandParent instanceof PsiCodeBlock)) {
            blockStatement = (PsiBlockStatement)factory2.createStatementFromText("{}", forStatement);
            codeBlock = blockStatement.getCodeBlock();
        } else {
            blockStatement = null;
            codeBlock = null;
        }
        for (i2 = 1; i2 < declaredElements.length; ++i2) {
            declaredElement = declaredElements[i2];
            if (!(declaredElement instanceof PsiVariable)) continue;
            PsiVariable variable2 = (PsiVariable)declaredElement;
            PsiType type2 = variable2.getType();
            String typeText = type2.getCanonicalText();
            StringBuilder newStatementText = new StringBuilder(typeText);
            newStatementText.append(' ');
            newStatementText.append(variable2.getName());
            PsiExpression initializer2 = variable2.getInitializer();
            if (initializer2 != null) {
                newStatementText.append('=');
                newStatementText.append(initializer2.getText());
            }
            newStatementText.append(';');
            PsiStatement newStatement = factory2.createStatementFromText(newStatementText.toString(), forStatement);
            if (codeBlock == null) {
                greatGreatGrandParent.addBefore(newStatement, forStatement);
                continue;
            }
            codeBlock.add(newStatement);
        }
        for (i2 = 1; i2 < declaredElements.length; ++i2) {
            declaredElement = declaredElements[i2];
            if (!(declaredElement instanceof PsiVariable)) continue;
            declaredElement.delete();
        }
        if (codeBlock != null) {
            codeBlock.add(forStatement);
            forStatement.replace(blockStatement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/NormalizeDeclarationFix", "getFamilyName"));
    }
}

