/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.NotNull;

public class SamePackageImportInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("import.from.same.package.display.name", new Object[0]);
        if (string == null) {
            SamePackageImportInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("import.from.same.package.problem.descriptor", new Object[0]);
        if (string == null) {
            SamePackageImportInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SamePackageImportVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/imports/SamePackageImportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SamePackageImportVisitor
    extends BaseInspectionVisitor {
        private SamePackageImportVisitor() {
        }

        @Override
        public void visitImportList(PsiImportList importList) {
            PsiImportStatement[] importStatements;
            PsiElement parent2 = importList.getParent();
            if (!(parent2 instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent2;
            String packageName = javaFile.getPackageName();
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
                if (reference == null) continue;
                String text2 = importStatement.getQualifiedName();
                if (importStatement.isOnDemand()) {
                    if (!packageName.equals(text2)) continue;
                    this.registerError((PsiElement)importStatement, new Object[0]);
                    continue;
                }
                if (text2 == null) {
                    return;
                }
                int classNameIndex = text2.lastIndexOf(46);
                String parentName = classNameIndex < 0 ? "" : text2.substring(0, classNameIndex);
                if (!packageName.equals(parentName)) continue;
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }
    }
}

