/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.inheritance.StaticInheritanceFix;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StaticInheritanceInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.inheritance.display.name", new Object[0]);
        if (string == null) {
            StaticInheritanceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("static.inheritance.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticInheritanceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new StaticInheritanceFix(false), new StaticInheritanceFix(true)};
        if (inspectionGadgetsFixArray == null) {
            StaticInheritanceInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticInheritanceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/StaticInheritanceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StaticInheritanceVisitor
    extends BaseInspectionVisitor {
        private StaticInheritanceVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiJavaCodeReferenceElement[] references;
            PsiReferenceList implementsList;
            if (aClass2 == null) {
                StaticInheritanceVisitor.$$$reportNull$$$0(0);
            }
            if ((implementsList = aClass2.getImplementsList()) == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement reference : references = implementsList.getReferenceElements()) {
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass targetClass = (PsiClass)target;
                if (!targetClass.isInterface() || !StaticInheritanceVisitor.interfaceContainsOnlyConstants(targetClass, new HashSet<PsiClass>())) continue;
                this.registerError((PsiElement)reference, new Object[0]);
            }
        }

        private static boolean interfaceContainsOnlyConstants(PsiClass anInterface, Set<PsiClass> visitedInterfaces) {
            PsiClass[] parentInterfaces;
            if (!visitedInterfaces.add(anInterface)) {
                return true;
            }
            if (anInterface.getAllFields().length == 0) {
                return false;
            }
            if (anInterface.getMethods().length != 0) {
                return false;
            }
            for (PsiClass parentInterface : parentInterfaces = anInterface.getInterfaces()) {
                if (StaticInheritanceVisitor.interfaceContainsOnlyConstants(parentInterface, visitedInterfaces)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/StaticInheritanceInspection$StaticInheritanceVisitor", "visitClass"));
        }
    }
}

