/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.ReplaceAssertEqualsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsCalledOnArrayInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assertequals.called.on.arrays.display.name", new Object[0]);
        if (string == null) {
            AssertEqualsCalledOnArrayInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("assertequals.called.on.arrays.problem.descriptor", new Object[0]);
        if (string == null) {
            AssertEqualsCalledOnArrayInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ReplaceAssertEqualsFix("assertArrayEquals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsOnArrayVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/AssertEqualsCalledOnArrayInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AssertEqualsOnArrayVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsOnArrayVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, false);
            if (assertHint == null) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            int argIndex = assertHint.getArgIndex();
            PsiType type1 = arguments2[argIndex].getType();
            PsiType type2 = arguments2[argIndex + 1].getType();
            if (!(type1 instanceof PsiArrayType) || !(type2 instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

