/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlaceholderCountMatchesArgumentCountInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> loggingMethodNames = ContainerUtilRt.newHashSet("log", "trace", "debug", "info", "warn", "error", "fatal");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.display.name", new Object[0]);
        if (string == null) {
            PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        Integer argumentCount = (Integer)infos2[0];
        Integer placeholderCount = (Integer)infos2[1];
        if (argumentCount > placeholderCount) {
            String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.more.problem.descriptor", argumentCount, placeholderCount);
            if (string == null) {
                PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.fewer.problem.descriptor", argumentCount, placeholderCount);
        if (string == null) {
            PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PlaceholderCountMatchesArgumentCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/logging/PlaceholderCountMatchesArgumentCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PlaceholderCountMatchesArgumentCountVisitor
    extends BaseInspectionVisitor {
        private PlaceholderCountMatchesArgumentCountVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            int argumentCount;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!loggingMethodNames.contains(name)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(aClass2, "org.slf4j.Logger") && !InheritanceUtil.isInheritor(aClass2, "org.apache.logging.log4j.Logger")) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression logStringArgument = arguments2[0];
            if (!ExpressionUtils.hasStringType(logStringArgument)) {
                if (arguments2.length < 2) {
                    return;
                }
                logStringArgument = arguments2[1];
                argumentCount = PlaceholderCountMatchesArgumentCountVisitor.countArguments(arguments2, 2);
            } else {
                argumentCount = PlaceholderCountMatchesArgumentCountVisitor.countArguments(arguments2, 1);
            }
            int placeholderCount = PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(logStringArgument);
            if (placeholderCount < 0 || argumentCount < 0 || placeholderCount == argumentCount) {
                return;
            }
            if (placeholderCount > 1 && placeholderCount == argumentCount + 1 && PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(arguments2[arguments2.length - 1])) {
                return;
            }
            this.registerError((PsiElement)logStringArgument, argumentCount, placeholderCount);
        }

        private static boolean hasThrowableType(PsiExpression lastArgument) {
            PsiType type2 = lastArgument.getType();
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (InheritanceUtil.isInheritor(disjunction, "java.lang.Throwable")) continue;
                    return false;
                }
                return true;
            }
            return InheritanceUtil.isInheritor(type2, "java.lang.Throwable");
        }

        public static int countPlaceholders(PsiExpression expression2) {
            Object value = ExpressionUtils.computeConstantExpression(expression2);
            if (value == null) {
                StringBuilder builder = new StringBuilder();
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(expression2, builder) ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(builder.toString()) : -1;
            }
            return value instanceof String ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders((String)value) : 0;
        }

        private static boolean buildString(PsiExpression expression2, StringBuilder builder) {
            PsiType type2 = expression2.getType();
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(parenthesizedExpression.getExpression(), builder);
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                if (!TypeUtils.isJavaLangString(type2) && !PsiType.CHAR.equals(type2)) {
                    return true;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (PlaceholderCountMatchesArgumentCountVisitor.buildString(operand, builder)) continue;
                    return false;
                }
                return true;
            }
            if (expression2 instanceof PsiLiteralExpression) {
                if (TypeUtils.isJavaLangString(type2) || PsiType.CHAR.equals(type2)) {
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
                    builder.append(literalExpression.getValue());
                }
                return true;
            }
            if (!TypeUtils.isJavaLangString(type2)) {
                return true;
            }
            Object value = ExpressionUtils.computeConstantExpression(expression2);
            if (value == null) {
                return false;
            }
            builder.append(value);
            return true;
        }

        private static int countPlaceholders(String string) {
            int count2 = 0;
            int index2 = string.indexOf("{}");
            while (index2 >= 0) {
                if (index2 == 0 || string.charAt(index2 - 1) != '\\') {
                    ++count2;
                }
                index2 = string.indexOf("{}", index2 + 1);
            }
            return count2;
        }

        private static int countArguments(PsiExpression[] arguments2, int countFrom) {
            PsiExpression argument;
            PsiType argumentType;
            if (arguments2.length <= countFrom) {
                return 0;
            }
            int count2 = arguments2.length - countFrom;
            if (count2 == 1 && (argumentType = (argument = arguments2[countFrom]).getType()) instanceof PsiArrayType) {
                PsiNewExpression newExpression;
                PsiArrayInitializerExpression arrayInitializerExpression;
                if (argumentType.equalsToText("java.lang.Object[]") && argument instanceof PsiNewExpression && (arrayInitializerExpression = (newExpression = (PsiNewExpression)argument).getArrayInitializer()) != null) {
                    return arrayInitializerExpression.getInitializers().length;
                }
                return -1;
            }
            PsiExpression lastArgument = arguments2[arguments2.length - 1];
            return PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(lastArgument) ? count2 - 1 : count2;
        }
    }
}

