/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import org.jetbrains.annotations.NotNull;

public class AnonymousInnerClassMayBeStaticInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.display.name", new Object[0]);
        if (string == null) {
            AnonymousInnerClassMayBeStaticInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.problem.descriptor", new Object[0]);
        if (string == null) {
            AnonymousInnerClassMayBeStaticInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousInnerClassMayBeStaticVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/AnonymousInnerClassMayBeStaticInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AnonymousInnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private AnonymousInnerClassMayBeStaticVisitor() {
        }

        @Override
        public void visitAnonymousClass(@NotNull PsiAnonymousClass anonymousClass) {
            if (anonymousClass == null) {
                AnonymousInnerClassMayBeStaticVisitor.$$$reportNull$$$0(0);
            }
            if (anonymousClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            PsiMember containingMember = PsiTreeUtil.getParentOfType((PsiElement)anonymousClass, PsiMember.class);
            if (containingMember == null || containingMember.hasModifierProperty("static")) {
                return;
            }
            PsiJavaCodeReferenceElement reference = anonymousClass.getBaseClassReference();
            if (reference.resolve() == null) {
                return;
            }
            PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)anonymousClass, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                return;
            }
            InnerClassReferenceVisitor visitor2 = new InnerClassReferenceVisitor(anonymousClass);
            anonymousClass.accept(visitor2);
            if (!visitor2.canInnerClassBeStatic()) {
                return;
            }
            if (AnonymousInnerClassMayBeStaticVisitor.hasReferenceToLocalClass(anonymousClass)) {
                return;
            }
            this.registerClassError(anonymousClass, new Object[0]);
        }

        private static boolean hasReferenceToLocalClass(PsiAnonymousClass anonymousClass) {
            LocalClassReferenceVisitor visitor2 = new LocalClassReferenceVisitor();
            anonymousClass.accept(visitor2);
            return visitor2.hasReferenceToLocalClass();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/siyeh/ig/memory/AnonymousInnerClassMayBeStaticInspectionBase$AnonymousInnerClassMayBeStaticVisitor", "visitAnonymousClass"));
        }

        private static class LocalClassReferenceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private boolean referenceToLocalClass;

            private LocalClassReferenceVisitor() {
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (reference.getQualifier() != null) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiClass) || !PsiUtil.isLocalClass((PsiClass)target)) {
                    return;
                }
                this.referenceToLocalClass = true;
            }

            private boolean hasReferenceToLocalClass() {
                return this.referenceToLocalClass;
            }
        }
    }
}

