/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InnerClassMayBeStaticInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.display.name", new Object[0]);
        if (string == null) {
            InnerClassMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            InnerClassMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new InnerClassMayBeStaticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassMayBeStaticVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/InnerClassMayBeStaticInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private InnerClassMayBeStaticVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiClass[] innerClasses2;
            if (aClass2 == null) {
                InnerClassMayBeStaticVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.getContainingClass() != null && !aClass2.hasModifierProperty("static")) {
                return;
            }
            if (aClass2 instanceof PsiAnonymousClass) {
                return;
            }
            for (PsiClass innerClass : innerClasses2 = aClass2.getInnerClasses()) {
                if (innerClass.hasModifierProperty("static")) continue;
                InnerClassReferenceVisitor visitor2 = new InnerClassReferenceVisitor(innerClass);
                innerClass.accept(visitor2);
                if (!visitor2.canInnerClassBeStatic()) continue;
                this.registerClassError(innerClass, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticVisitor", "visitClass"));
        }
    }

    private static class InnerClassMayBeStaticFix
    extends InspectionGadgetsFix {
        private InnerClassMayBeStaticFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.static.quickfix", new Object[0]);
            if (string == null) {
                InnerClassMayBeStaticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiJavaToken classNameToken = (PsiJavaToken)descriptor2.getPsiElement();
            PsiClass innerClass = (PsiClass)classNameToken.getParent();
            if (innerClass == null) {
                return;
            }
            SearchScope useScope = innerClass.getUseScope();
            Query<PsiReference> query = ReferencesSearch.search(innerClass, useScope);
            Collection<PsiReference> references = query.findAll();
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>(references.size() + 1);
            for (PsiReference reference : references) {
                elements.add(reference.getElement());
            }
            elements.add(innerClass);
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            WriteAction.run(() -> InnerClassMayBeStaticFix.makeStatic(innerClass, references));
        }

        private static void makeStatic(PsiClass innerClass, Collection<PsiReference> references) {
            Project project = innerClass.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            for (PsiReference reference : references) {
                PsiExpressionList argumentList2;
                PsiNewExpression newExpression;
                PsiJavaCodeReferenceElement classReference;
                PsiElement element = reference.getElement();
                PsiElement parent2 = element.getParent();
                if (!(parent2 instanceof PsiNewExpression) || (classReference = (newExpression = (PsiNewExpression)parent2).getClassReference()) == null || (argumentList2 = newExpression.getArgumentList()) == null) continue;
                PsiReferenceParameterList parameterList = classReference.getParameterList();
                String genericParameters = parameterList != null ? parameterList.getText() : "";
                PsiExpression expression2 = factory2.createExpressionFromText("new " + classReference.getQualifiedName() + genericParameters + argumentList2.getText(), innerClass);
                codeStyleManager.shortenClassReferences(newExpression.replace(expression2));
            }
            PsiModifierList modifiers2 = innerClass.getModifierList();
            if (modifiers2 == null) {
                return;
            }
            modifiers2.setModifierProperty("static", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticFix", "getFamilyName"));
        }
    }
}

