/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceEmptyArrayToConstantFix
extends InspectionGadgetsFix {
    private final String myText;
    private final String myName;

    public ReplaceEmptyArrayToConstantFix(PsiClass aClass2, PsiField field) {
        this.myText = aClass2.getQualifiedName() + "." + field.getName();
        this.myName = InspectionGadgetsBundle.message("replace.with", aClass2.getName() + "." + field.getName());
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("constant.for.zero.length.array.quickfix.family", new Object[0]);
        if (string == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiExpression newExp = JavaPsiFacade.getInstance(project).getElementFactory().createExpressionFromText(this.myText, descriptor2.getPsiElement());
        PsiElement element = descriptor2.getPsiElement().replace(newExp);
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/ReplaceEmptyArrayToConstantFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

