/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.CouplingVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MethodCouplingInspection
extends MethodMetricInspection {
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @Override
    @NotNull
    public String getID() {
        if ("OverlyCoupledMethod" == null) {
            MethodCouplingInspection.$$$reportNull$$$0(0);
        }
        return "OverlyCoupledMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.coupling.display.name", new Object[0]);
        if (string == null) {
            MethodCouplingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer coupling = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("method.coupling.problem.descriptor", coupling);
        if (string == null) {
            MethodCouplingInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.coupling.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String configurationLabel = this.getConfigurationLabel();
        JLabel label2 = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)label2, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 0;
        panel.add((Component)valueField, constraints);
        CheckBox arrayCheckBox = new CheckBox(InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), this, "m_includeJavaClasses");
        CheckBox objectCheckBox = new CheckBox(InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), this, "m_includeLibraryClasses");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)arrayCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        panel.add((Component)objectCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCouplingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/MethodCouplingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodCouplingVisitor
    extends BaseInspectionVisitor {
        private MethodCouplingVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodCouplingVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            CouplingVisitor visitor2 = new CouplingVisitor(method, MethodCouplingInspection.this.m_includeJavaClasses, MethodCouplingInspection.this.m_includeLibraryClasses);
            method.accept(visitor2);
            int coupling = visitor2.getNumDependencies();
            if (coupling <= MethodCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, coupling);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MethodCouplingInspection$MethodCouplingVisitor", "visitMethod"));
        }
    }
}

