/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TryWithIdenticalCatchesInspection
extends BaseInspection {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiType type2 = (PsiType)infos2[0];
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.display.name", new Object[0]);
        if (string == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher(file2);
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        PsiCatchSection catchSection;
        PsiParameter parameter;
        if (element == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiCatchSection && (parameter = (catchSection = (PsiCatchSection)element).getParameter()) != null && super.isSuppressedFor(parameter)) {
            return true;
        }
        return super.isSuppressedFor(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryWithIdenticalCatchesVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new CollapseCatchSectionsFix((Integer)infos2[1], (Integer)infos2[2]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollapseCatchSectionsFix
    extends InspectionGadgetsFix {
        private final int myCollapseIntoIndex;
        private final int mySectionIndex;

        public CollapseCatchSectionsFix(int collapseIntoIndex, int sectionIndex) {
            this.myCollapseIntoIndex = collapseIntoIndex;
            this.mySectionIndex = sectionIndex;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.with.identical.catches.quickfix", new Object[0]);
            if (string == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiType type2;
            PsiTryStatement tryStatement = (PsiTryStatement)descriptor2.getPsiElement().getParent();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            if (this.myCollapseIntoIndex >= catchSections.length || this.mySectionIndex >= catchSections.length) {
                return;
            }
            PsiCatchSection collapseInto = catchSections[this.myCollapseIntoIndex];
            PsiCatchSection section2 = catchSections[this.mySectionIndex];
            PsiParameter parameter1 = collapseInto.getParameter();
            PsiParameter parameter2 = section2.getParameter();
            if (parameter1 == null || parameter2 == null) {
                return;
            }
            PsiType type1 = parameter1.getType();
            if (TypeConversionUtil.isAssignable(type1, type2 = parameter2.getType())) {
                section2.delete();
                return;
            }
            if (TypeConversionUtil.isAssignable(type2, type1)) {
                collapseInto.delete();
                return;
            }
            ArrayList<PsiType> types = new ArrayList<PsiType>();
            CollapseCatchSectionsFix.collectDisjunctTypes(type1, types);
            CollapseCatchSectionsFix.collectDisjunctTypes(type2, types);
            StringBuilder typeText = new StringBuilder();
            for (PsiType type3 : types) {
                if (typeText.length() > 0) {
                    typeText.append(" | ");
                }
                typeText.append(type3.getCanonicalText());
            }
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory(project).createTypeElementFromText(typeText.toString(), tryStatement);
            PsiTypeElement typeElement = parameter1.getTypeElement();
            if (typeElement == null) {
                return;
            }
            typeElement.replace(newTypeElement);
            section2.delete();
        }

        private static void collectDisjunctTypes(PsiType type2, List<PsiType> out) {
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                List<PsiType> disjunctions = disjunctionType.getDisjunctions();
                for (PsiType disjunction : disjunctions) {
                    CollapseCatchSectionsFix.collectDisjunctTypes(disjunction, out);
                }
                return;
            }
            Iterator<PsiType> iterator2 = out.iterator();
            while (iterator2.hasNext()) {
                PsiType collectedType = iterator2.next();
                if (TypeConversionUtil.isAssignable(type2, collectedType)) {
                    iterator2.remove();
                    continue;
                }
                if (!TypeConversionUtil.isAssignable(collectedType, type2)) continue;
                return;
            }
            out.add(type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CollapseCatchSectionsFix", "getFamilyName"));
        }
    }

    private static class TryWithIdenticalCatchesVisitor
    extends BaseInspectionVisitor {
        private TryWithIdenticalCatchesVisitor() {
        }

        @Override
        public void visitTryStatement(PsiTryStatement statement2) {
            super.visitTryStatement(statement2);
            PsiCatchSection[] catchSections = statement2.getCatchSections();
            if (catchSections.length < 2) {
                return;
            }
            PsiParameter[] parameters2 = statement2.getCatchBlockParameters();
            if (catchSections.length != parameters2.length) {
                return;
            }
            boolean[] duplicates = new boolean[catchSections.length];
            for (int i2 = 0; i2 < catchSections.length - 1; ++i2) {
                PsiParameter parameter;
                PsiCatchSection catchSection = catchSections[i2];
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (catchBlock == null || (parameter = catchSection.getParameter()) == null) continue;
                DuplicatesFinder finder = TryWithIdenticalCatchesVisitor.buildDuplicatesFinder(catchBlock, parameter);
                for (int j = i2 + 1; j < catchSections.length; ++j) {
                    DuplicatesFinder reverseFinder;
                    Match otherMatch;
                    Match match2;
                    PsiParameter otherParameter;
                    PsiCatchSection otherSection;
                    PsiCodeBlock otherCatchBlock;
                    if (duplicates[j] || (otherCatchBlock = (otherSection = catchSections[j]).getCatchBlock()) == null || (otherParameter = otherSection.getParameter()) == null || (match2 = finder.isDuplicate(otherCatchBlock, true)) == null || (otherMatch = (reverseFinder = TryWithIdenticalCatchesVisitor.buildDuplicatesFinder(otherCatchBlock, otherParameter)).isDuplicate(catchBlock, true)) == null) continue;
                    ReturnValue returnValue = match2.getReturnValue();
                    ReturnValue otherReturnValue = otherMatch.getReturnValue();
                    if ((returnValue != null ? !returnValue.isEquivalent(otherReturnValue) : otherReturnValue != null) || (j <= i2 ? !TryWithIdenticalCatchesVisitor.canCollapse(parameters2, j, i2) : !TryWithIdenticalCatchesVisitor.canCollapse(parameters2, i2, j))) continue;
                    PsiJavaToken rParenth = otherSection.getRParenth();
                    if (rParenth != null) {
                        this.registerErrorAtOffset((PsiElement)otherSection, 0, rParenth.getStartOffsetInParent() + 1, catchSection.getParameter().getType(), i2, j);
                    }
                    duplicates[i2] = true;
                    duplicates[j] = true;
                }
            }
        }

        private static DuplicatesFinder buildDuplicatesFinder(@NotNull PsiCodeBlock catchBlock, @NotNull PsiParameter parameter) {
            if (catchBlock == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(1);
            }
            InputVariables inputVariables = new InputVariables(Collections.singletonList(parameter), parameter.getProject(), new LocalSearchScope(catchBlock), false);
            return new DuplicatesFinder(new PsiElement[]{catchBlock}, inputVariables, null, Collections.emptyList());
        }

        private static boolean canCollapse(PsiParameter[] parameters2, int index1, int index2) {
            if (index2 <= index1) {
                throw new IllegalArgumentException();
            }
            PsiType type2 = parameters2[index2].getType();
            for (int i2 = index1 + 1; i2 < index2; ++i2) {
                PsiType otherType = parameters2[i2].getType();
                if (!TypeConversionUtil.isAssignable(type2, otherType)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "catchBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$TryWithIdenticalCatchesVisitor";
            objectArray[2] = "buildDuplicatesFinder";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

