/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntegerMultiplicationImplicitCastToLongInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_typesToCheck = new HashSet<String>(4);
    public boolean ignoreNonOverflowingCompileTimeConstants = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.display.name", new Object[0]);
        if (string == null) {
            IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        IElementType tokenType = (IElementType)infos2[0];
        if (JavaTokenType.ASTERISK.equals(tokenType)) {
            String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.problem.descriptor", new Object[0]);
            if (string == null) {
                IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("integer.shift.implicit.cast.to.long.problem.descriptor", new Object[0]);
        if (string == null) {
            IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.option", new Object[0]), this, "ignoreNonOverflowingCompileTimeConstants");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerMultiplicationImplicitlyCastToLongVisitor();
    }

    static {
        s_typesToCheck.add("int");
        s_typesToCheck.add("short");
        s_typesToCheck.add("byte");
        s_typesToCheck.add("char");
        s_typesToCheck.add("java.lang.Integer");
        s_typesToCheck.add("java.lang.Short");
        s_typesToCheck.add("java.lang.Byte");
        s_typesToCheck.add("java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class IntegerMultiplicationImplicitlyCastToLongVisitor
    extends BaseInspectionVisitor {
        private IntegerMultiplicationImplicitlyCastToLongVisitor() {
        }

        @Override
        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            if (expression2 == null) {
                IntegerMultiplicationImplicitlyCastToLongVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.LTLT)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!this.isNonLongInteger(type2)) {
                return;
            }
            if (expression2.getOperands().length < 2 || expression2.getLastChild() instanceof PsiErrorElement) {
                return;
            }
            PsiExpression context = this.getContainingExpression(expression2);
            if (context == null) {
                return;
            }
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                return;
            }
            if (!contextType.equals(PsiType.LONG)) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.this.ignoreNonOverflowingCompileTimeConstants) {
                try {
                    if (ExpressionUtils.computeConstantExpression(expression2, true) != null) {
                        return;
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
            }
            this.registerError((PsiElement)expression2, tokenType);
        }

        private PsiExpression getContainingExpression(PsiExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiBinaryExpression || parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiPrefixExpression || parent2 instanceof PsiConditionalExpression) {
                return this.getContainingExpression((PsiExpression)parent2);
            }
            return expression2;
        }

        private boolean isNonLongInteger(PsiType type2) {
            if (type2 == null) {
                return false;
            }
            String text2 = type2.getCanonicalText();
            return text2 != null && s_typesToCheck.contains(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection$IntegerMultiplicationImplicitlyCastToLongVisitor", "visitPolyadicExpression"));
        }
    }
}

