/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

class RemoveLeadingZeroFix
extends InspectionGadgetsFix {
    RemoveLeadingZeroFix() {
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("remove.leading.zero.to.make.decimal.quickfix", new Object[0]);
        if (string == null) {
            RemoveLeadingZeroFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        PsiLiteralExpression literal = (PsiLiteralExpression)element;
        RemoveLeadingZeroFix.removeLeadingZeroes(literal);
    }

    static void removeLeadingZeroes(PsiLiteralExpression literal) {
        int index2;
        String text2 = literal.getText();
        int max = text2.length() - (PsiType.LONG.equals(literal.getType()) ? 2 : 1);
        if (max < 1) {
            return;
        }
        for (index2 = 0; index2 < max && (text2.charAt(index2) == '0' || text2.charAt(index2) == '_'); ++index2) {
        }
        String textWithoutLeadingZeros = text2.substring(index2);
        PsiReplacementUtil.replaceExpression(literal, textWithoutLeadingZeros);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/RemoveLeadingZeroFix", "getFamilyName"));
    }
}

