/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.CanBeStaticVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public class FieldMayBeStaticInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.may.be.static.display.name", new Object[0]);
        if (string == null) {
            FieldMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldMayBeStaticVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("field.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            FieldMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ChangeModifierFix("static");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/FieldMayBeStaticInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class FieldMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private FieldMayBeStaticVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                FieldMayBeStaticVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("static")) {
                return;
            }
            if (!field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer2 = field.getInitializer();
            if (initializer2 == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(initializer2)) {
                return;
            }
            PsiType type2 = field.getType();
            if (!ClassUtils.isImmutable(type2)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass != null && !containingClass.hasModifierProperty("static") && containingClass.getContainingClass() != null && !PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass && !PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
                return;
            }
            if (!FieldMayBeStaticVisitor.canBeStatic(initializer2)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static boolean canBeStatic(PsiExpression initializer2) {
            CanBeStaticVisitor canBeStaticVisitor = new CanBeStaticVisitor();
            initializer2.accept(canBeStaticVisitor);
            return canBeStaticVisitor.canBeStatic();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/performance/FieldMayBeStaticInspection$FieldMayBeStaticVisitor", "visitField"));
        }
    }
}

