/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferToStringInConcatenationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.display.name", new Object[0]);
        if (string == null) {
            StringBufferToStringInConcatenationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String className2 = (String)infos2[0];
        String string = InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.problem.descriptor", className2);
        if (string == null) {
            StringBufferToStringInConcatenationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferToStringVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new StringBufferToStringFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringBufferToStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferToStringVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                StringBufferToStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!ExpressionUtils.isStringConcatenationOperand(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"toString".equals(referenceName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            String className2 = aClass2.getQualifiedName();
            if (!"java.lang.StringBuffer".equals(className2) && !"java.lang.StringBuilder".equals(className2)) {
                return;
            }
            this.registerMethodCallError(expression2, aClass2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection$StringBufferToStringVisitor", "visitMethodCallExpression"));
        }
    }

    private static class StringBufferToStringFix
    extends InspectionGadgetsFix {
        private StringBufferToStringFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.remove.quickfix", new Object[0]);
            if (string == null) {
                StringBufferToStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement methodNameToken = descriptor2.getPsiElement();
            PsiElement methodCallExpression = methodNameToken.getParent();
            assert (methodCallExpression != null);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodCallExpression.getParent();
            assert (methodCall != null);
            PsiReferenceExpression expression2 = methodCall.getMethodExpression();
            PsiExpression qualifier = expression2.getQualifierExpression();
            assert (qualifier != null);
            String newExpression = qualifier.getText();
            PsiReplacementUtil.replaceExpression(methodCall, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection$StringBufferToStringFix", "getFamilyName"));
        }
    }
}

