/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringEqualsEmptyStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.display.name", new Object[0]);
        if (string == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        boolean useIsEmpty = (Boolean)infos2[0];
        if (useIsEmpty) {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.is.empty.problem.descriptor", new Object[0]);
            if (string == null) {
                StringEqualsEmptyStringInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.problem.descriptor", new Object[0]);
        if (string == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        boolean useIsEmpty = (Boolean)infos2[0];
        return new StringEqualsEmptyStringFix(useIsEmpty);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call2) {
            if (call2 == null) {
                StringEqualsEmptyStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call2);
            PsiReferenceExpression methodExpression = call2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList2 = call2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 1) {
                return;
            }
            PsiElement context = call2.getParent();
            boolean useIsEmpty = PsiUtil.isLanguageLevel6OrHigher(call2);
            if (!useIsEmpty && context instanceof PsiExpressionStatement) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression argument = arguments2[0];
            if (ExpressionUtils.isEmptyStringLiteral(qualifier)) {
                PsiType type2 = argument.getType();
                if (!TypeUtils.isJavaLangString(type2)) {
                    return;
                }
            } else if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                if (qualifier == null) {
                    return;
                }
                PsiType type3 = qualifier.getType();
                if (!TypeUtils.isJavaLangString(type3)) {
                    return;
                }
            } else {
                return;
            }
            this.registerMethodCallError(call2, useIsEmpty);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringVisitor", "visitMethodCallExpression"));
        }
    }

    private static class StringEqualsEmptyStringFix
    extends InspectionGadgetsFix {
        private final boolean useIsEmpty;

        public StringEqualsEmptyStringFix(boolean useIsEmpty) {
            this.useIsEmpty = useIsEmpty;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.useIsEmpty) {
                String string = InspectionGadgetsBundle.message("string.equals.empty.string.isempty.quickfix", new Object[0]);
                if (string == null) {
                    StringEqualsEmptyStringFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.quickfix", new Object[0]);
            if (string == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify empty string check" == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(2);
            }
            return "Simplify empty string check";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiExpression expressionToReplace;
            StringBuilder newExpression;
            boolean addNullCheck;
            PsiExpression checkedExpression;
            PsiIdentifier name = (PsiIdentifier)descriptor2.getPsiElement();
            PsiReferenceExpression expression2 = (PsiReferenceExpression)name.getParent();
            if (expression2 == null) {
                return;
            }
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression2.getParent();
            PsiExpressionList argumentList2 = call2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            PsiExpression argument = arguments2[0];
            if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                checkedExpression = this.getCheckedExpression(qualifier);
                addNullCheck = false;
            } else {
                checkedExpression = this.getCheckedExpression(argument);
                boolean bl = addNullCheck = !StringEqualsEmptyStringFix.isCheckedForNull(checkedExpression);
            }
            if (addNullCheck) {
                newExpression = new StringBuilder(checkedExpression.getText());
                newExpression.append("!=null&&");
            } else {
                newExpression = new StringBuilder("");
            }
            PsiElement parent2 = call2.getParent();
            if (parent2 instanceof PsiExpression) {
                PsiExpression parentExpression = (PsiExpression)parent2;
                if (BoolUtils.isNegation(parentExpression)) {
                    expressionToReplace = parentExpression;
                    if (this.useIsEmpty) {
                        newExpression.append('!').append(checkedExpression.getText()).append(".isEmpty()");
                    } else {
                        newExpression.append(checkedExpression.getText()).append(".length()!=0");
                    }
                } else {
                    expressionToReplace = call2;
                    if (this.useIsEmpty) {
                        newExpression.append(checkedExpression.getText()).append(".isEmpty()");
                    } else {
                        newExpression.append(checkedExpression.getText()).append(".length()==0");
                    }
                }
            } else {
                expressionToReplace = call2;
                if (this.useIsEmpty) {
                    newExpression.append(checkedExpression.getText()).append(".isEmpty()");
                } else {
                    newExpression.append(checkedExpression.getText()).append(".length()==0");
                }
            }
            PsiReplacementUtil.replaceExpression(expressionToReplace, newExpression.toString());
        }

        private static boolean isCheckedForNull(PsiExpression expression2) {
            PsiPolyadicExpression polyadicExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiPolyadicExpression.class, true, PsiStatement.class, PsiVariable.class);
            if (polyadicExpression == null) {
                return false;
            }
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (PsiTreeUtil.isAncestor(operand, expression2, true)) {
                    return false;
                }
                if (!(operand instanceof PsiBinaryExpression)) continue;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
                IElementType operationTokenType = binaryExpression.getOperationTokenType();
                if (JavaTokenType.ANDAND.equals(tokenType) ? !JavaTokenType.NE.equals(operationTokenType) : !JavaTokenType.OROR.equals(tokenType) || !JavaTokenType.EQEQ.equals(operationTokenType)) continue;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) continue;
                if (PsiType.NULL.equals(lhs.getType()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(expression2, rhs)) {
                    return true;
                }
                if (!PsiType.NULL.equals(rhs.getType()) || !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(expression2, lhs)) continue;
                return true;
            }
            return false;
        }

        private PsiExpression getCheckedExpression(PsiExpression expression2) {
            if (this.useIsEmpty || !(expression2 instanceof PsiMethodCallExpression)) {
                return expression2;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return expression2;
            }
            PsiType type2 = qualifierExpression.getType();
            if ("toString".equals(referenceName) && type2 != null && (type2.equalsToText("java.lang.StringBuffer") || type2.equalsToText("java.lang.StringBuilder"))) {
                return qualifierExpression;
            }
            return expression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

