/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

class StringVariableIsAppendedToVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean appendedTo;
    private final PsiVariable variable;
    private final boolean onlyWarnOnLoop;

    StringVariableIsAppendedToVisitor(PsiVariable variable2, boolean onlyWarnOnLoop) {
        this.variable = variable2;
        this.onlyWarnOnLoop = onlyWarnOnLoop;
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            StringVariableIsAppendedToVisitor.$$$reportNull$$$0(0);
        }
        if (this.appendedTo) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null) {
            return;
        }
        if (!(lhs instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier != null) {
            return;
        }
        PsiElement referent = reference.resolve();
        if (!this.variable.equals(referent)) {
            return;
        }
        IElementType tokenType = assignment.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.PLUSEQ)) {
            if (this.onlyWarnOnLoop && !ControlFlowUtils.isInLoop(assignment)) {
                return;
            }
            this.appendedTo = true;
        } else if (this.isConcatenation(rhs)) {
            if (this.onlyWarnOnLoop && !ControlFlowUtils.isInLoop(assignment)) {
                return;
            }
            this.appendedTo = true;
        }
    }

    private boolean isConcatenation(PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement referent = ((PsiReference)((Object)expression2)).resolve();
            return this.variable.equals(referent);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression body2 = parenthesizedExpression.getExpression();
            return this.isConcatenation(body2);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (!this.isConcatenation(operand)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAppendedTo() {
        return this.appendedTo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/performance/StringVariableIsAppendedToVisitor", "visitAssignmentExpression"));
    }
}

